<?php

/**
 * Single Product tabs
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/tabs/tabs.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.8.0
 */

if (! defined('ABSPATH')) {
	exit;
}

/**
 * Filter tabs and allow third parties to add their own.
 *
 * Each tab is an array containing title, callback and priority.
 *
 * @see woocommerce_default_product_tabs()
 */
global $product;
$product_tabs = apply_filters('woocommerce_product_tabs', array());
if (empty($product_tabs)) {
	return;
}

$logo_width     = get_option('site_logo_width');
$logo_height    = get_option('site_logo_height');
$site_text_one  = get_option("site_text_one");
$site_text_two  = get_option("site_text_two");
$site_logo      = get_option('site_logo');

$icons = [
	'description' => '<svg width="25" height="24" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
	<path d="M9.59375 2C8.76532 2 8.09375 2.67157 8.09375 3.5V4.5C8.09375 5.32843 8.76532 6 9.59375 6H14.5938C15.4222 6 16.0938 5.32843 16.0938 4.5V3.5C16.0938 2.67157 15.4222 2 14.5938 2H9.59375Z" fill="#020308" fill-opacity="0.64"/>
	<path fill-rule="evenodd" clip-rule="evenodd" d="M6.59375 4.03662C5.33584 4.10719 4.54173 4.30764 3.97243 4.87694C3.09375 5.75562 3.09375 7.16983 3.09375 9.99826V15.9983C3.09375 18.8267 3.09375 20.2409 3.97243 21.1196C4.85111 21.9983 6.26532 21.9983 9.09375 21.9983H15.0938C17.9222 21.9983 19.3364 21.9983 20.2151 21.1196C21.0938 20.2409 21.0938 18.8267 21.0938 15.9983V9.99826C21.0938 7.16983 21.0938 5.75562 20.2151 4.87694C19.6458 4.30764 18.8517 4.10719 17.5938 4.03662V4.5C17.5938 6.15685 16.2506 7.5 14.5938 7.5H9.59375C7.9369 7.5 6.59375 6.15685 6.59375 4.5V4.03662ZM7.09375 13.75C6.67954 13.75 6.34375 14.0858 6.34375 14.5C6.34375 14.9142 6.67954 15.25 7.09375 15.25H15.0938C15.508 15.25 15.8438 14.9142 15.8438 14.5C15.8438 14.0858 15.508 13.75 15.0938 13.75H7.09375ZM7.09375 17.25C6.67954 17.25 6.34375 17.5858 6.34375 18C6.34375 18.4142 6.67954 18.75 7.09375 18.75H12.5938C13.008 18.75 13.3438 18.4142 13.3438 18C13.3438 17.5858 13.008 17.25 12.5938 17.25H7.09375Z" fill="#020308" fill-opacity="0.64"/>
	</svg>',

	'additional_information' => '
	<svg width="25" height="24" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M7.30948 3.26045C7.42907 2.13044 8.38515 1.25 9.54688 1.25H14.5469C15.7086 1.25 16.6647 2.13044 16.7843 3.26045C17.5474 3.27599 18.2072 3.31546 18.7705 3.41895C19.5285 3.55818 20.1736 3.82342 20.6985 4.34835C21.3004 4.95027 21.5593 5.70814 21.6804 6.60825C21.7969 7.47522 21.7969 8.57754 21.7969 9.94513V16.0549C21.7969 17.4225 21.7969 18.5248 21.6804 19.3918C21.5593 20.2919 21.3004 21.0497 20.6985 21.6517C20.0966 22.2536 19.3387 22.5125 18.4386 22.6335C17.5717 22.75 16.4693 22.75 15.1017 22.75H8.99201C7.62441 22.75 6.52209 22.75 5.65512 22.6335C4.75502 22.5125 3.99714 22.2536 3.39523 21.6517C2.79331 21.0497 2.53442 20.2919 2.4134 19.3918C2.29684 18.5248 2.29685 17.4225 2.29688 16.0549V9.94513C2.29685 8.57754 2.29684 7.47522 2.4134 6.60825C2.53442 5.70814 2.79331 4.95027 3.39523 4.34835C3.92016 3.82342 4.56523 3.55818 5.32323 3.41895C5.8866 3.31546 6.5464 3.27599 7.30948 3.26045ZM7.31184 4.76087C6.59366 4.7762 6.04024 4.81234 5.59422 4.89426C5.02741 4.99838 4.69934 5.16556 4.45589 5.40901C4.17912 5.68577 3.99868 6.07435 3.90002 6.80812C3.79847 7.56347 3.79688 8.56458 3.79688 10V16C3.79688 17.4354 3.79847 18.4365 3.90002 19.1919C3.99868 19.9257 4.17912 20.3142 4.45589 20.591C4.73265 20.8678 5.12122 21.0482 5.855 21.1469C6.61035 21.2484 7.61146 21.25 9.04688 21.25H15.0469C16.4823 21.25 17.4834 21.2484 18.2388 21.1469C18.9725 21.0482 19.3611 20.8678 19.6379 20.591C19.9146 20.3142 20.0951 19.9257 20.1937 19.1919C20.2953 18.4365 20.2969 17.4354 20.2969 16V10C20.2969 8.56458 20.2953 7.56347 20.1937 6.80812C20.0951 6.07434 19.9146 5.68577 19.6379 5.40901C19.3944 5.16556 19.0663 4.99838 18.4995 4.89426C18.0535 4.81234 17.5001 4.7762 16.7819 4.76087C16.6526 5.88062 15.7013 6.75 14.5469 6.75H9.54688C8.39247 6.75 7.44112 5.88062 7.31184 4.76087ZM9.54688 2.75C9.13266 2.75 8.79688 3.08579 8.79688 3.5V4.5C8.79688 4.91421 9.13266 5.25 9.54688 5.25H14.5469C14.9611 5.25 15.2969 4.91421 15.2969 4.5V3.5C15.2969 3.08579 14.9611 2.75 14.5469 2.75H9.54688ZM6.29688 10.5C6.29688 10.0858 6.63266 9.75 7.04688 9.75H7.54688C7.96109 9.75 8.29688 10.0858 8.29688 10.5C8.29688 10.9142 7.96109 11.25 7.54688 11.25H7.04688C6.63266 11.25 6.29688 10.9142 6.29688 10.5ZM9.79688 10.5C9.79688 10.0858 10.1327 9.75 10.5469 9.75H17.0469C17.4611 9.75 17.7969 10.0858 17.7969 10.5C17.7969 10.9142 17.4611 11.25 17.0469 11.25H10.5469C10.1327 11.25 9.79688 10.9142 9.79688 10.5ZM6.29688 14C6.29688 13.5858 6.63266 13.25 7.04688 13.25H7.54688C7.96109 13.25 8.29688 13.5858 8.29688 14C8.29688 14.4142 7.96109 14.75 7.54688 14.75H7.04688C6.63266 14.75 6.29688 14.4142 6.29688 14ZM9.79688 14C9.79688 13.5858 10.1327 13.25 10.5469 13.25H17.0469C17.4611 13.25 17.7969 13.5858 17.7969 14C17.7969 14.4142 17.4611 14.75 17.0469 14.75H10.5469C10.1327 14.75 9.79688 14.4142 9.79688 14ZM6.29688 17.5C6.29688 17.0858 6.63266 16.75 7.04688 16.75H7.54688C7.96109 16.75 8.29688 17.0858 8.29688 17.5C8.29688 17.9142 7.96109 18.25 7.54688 18.25H7.04688C6.63266 18.25 6.29688 17.9142 6.29688 17.5ZM9.79688 17.5C9.79688 17.0858 10.1327 16.75 10.5469 16.75H17.0469C17.4611 16.75 17.7969 17.0858 17.7969 17.5C17.7969 17.9142 17.4611 18.25 17.0469 18.25H10.5469C10.1327 18.25 9.79688 17.9142 9.79688 17.5Z" fill="#020308" fill-opacity="0.64"/>
</svg>
	',

	'reviews' => '
	<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M10.4606 1.25H13.5394C15.1427 1.24999 16.3997 1.24999 17.4039 1.34547C18.4274 1.44279 19.2655 1.64457 20.0044 2.09732C20.7781 2.57144 21.4286 3.22194 21.9027 3.99563C22.3554 4.73445 22.5572 5.57256 22.6545 6.59611C22.75 7.60029 22.75 8.85725 22.75 10.4606V11.5278C22.75 12.6691 22.75 13.564 22.7007 14.2868C22.6505 15.0223 22.5468 15.6344 22.3123 16.2004C21.7287 17.6093 20.6093 18.7287 19.2004 19.3123C18.3955 19.6457 17.4786 19.7197 16.2233 19.7413C15.7842 19.7489 15.5061 19.7545 15.2941 19.7779C15.096 19.7999 15.0192 19.832 14.9742 19.8582C14.9268 19.8857 14.8622 19.936 14.7501 20.0898C14.6287 20.2564 14.4916 20.4865 14.2742 20.8539L13.7321 21.7697C12.9585 23.0767 11.0415 23.0767 10.2679 21.7697L9.72579 20.8539C9.50835 20.4865 9.37122 20.2564 9.24985 20.0898C9.13772 19.936 9.07313 19.8857 9.02572 19.8582C8.98078 19.832 8.90399 19.7999 8.70588 19.7779C8.49387 19.7545 8.21575 19.7489 7.77666 19.7413C6.52138 19.7197 5.60454 19.6457 4.79957 19.3123C3.39066 18.7287 2.27128 17.6093 1.68769 16.2004C1.45323 15.6344 1.3495 15.0223 1.29932 14.2868C1.24999 13.564 1.25 12.6691 1.25 11.5278L1.25 10.4606C1.24999 8.85726 1.24999 7.60029 1.34547 6.59611C1.44279 5.57256 1.64457 4.73445 2.09732 3.99563C2.57144 3.22194 3.22194 2.57144 3.99563 2.09732C4.73445 1.64457 5.57256 1.44279 6.59611 1.34547C7.60029 1.24999 8.85726 1.24999 10.4606 1.25ZM6.73809 2.83873C5.82434 2.92561 5.24291 3.09223 4.77938 3.37628C4.20752 3.72672 3.72672 4.20752 3.37628 4.77938C3.09223 5.24291 2.92561 5.82434 2.83873 6.73809C2.75079 7.663 2.75 8.84876 2.75 10.5V11.5C2.75 12.6751 2.75041 13.5189 2.79584 14.1847C2.84081 14.8438 2.92737 15.2736 3.07351 15.6264C3.50486 16.6678 4.33223 17.4951 5.3736 17.9265C5.88923 18.1401 6.54706 18.2199 7.8025 18.2416L7.83432 18.2421C8.23232 18.249 8.58109 18.2549 8.87097 18.287C9.18246 18.3215 9.4871 18.3912 9.77986 18.5615C10.0702 18.7304 10.2795 18.9559 10.4621 19.2063C10.6307 19.4378 10.804 19.7306 11.0004 20.0623L11.5587 21.0057C11.7515 21.3313 12.2485 21.3313 12.4412 21.0057L12.9996 20.0623C13.1959 19.7306 13.3692 19.4378 13.5379 19.2063C13.7204 18.9559 13.9298 18.7304 14.2201 18.5615C14.5129 18.3912 14.8175 18.3215 15.129 18.287C15.4189 18.2549 15.7676 18.249 16.1656 18.2421L16.1975 18.2416C17.4529 18.2199 18.1108 18.1401 18.6264 17.9265C19.6678 17.4951 20.4951 16.6678 20.9265 15.6264C21.0726 15.2736 21.1592 14.8438 21.2042 14.1847C21.2496 13.5189 21.25 12.6751 21.25 11.5V10.5C21.25 8.84876 21.2492 7.663 21.1613 6.73809C21.0744 5.82434 20.9078 5.24291 20.6237 4.77938C20.2733 4.20752 19.7925 3.72672 19.2206 3.37628C18.7571 3.09223 18.1757 2.92561 17.2619 2.83873C16.337 2.75079 15.1512 2.75 13.5 2.75H10.5C8.84876 2.75 7.663 2.75079 6.73809 2.83873Z" fill="#020308" fill-opacity="0.64"/>
<path d="M9 11C9 11.5523 8.55228 12 8 12C7.44772 12 7 11.5523 7 11C7 10.4477 7.44772 10 8 10C8.55228 10 9 10.4477 9 11Z" fill="#020308" fill-opacity="0.64"/>
<path d="M13 11C13 11.5523 12.5523 12 12 12C11.4477 12 11 11.5523 11 11C11 10.4477 11.4477 10 12 10C12.5523 10 13 10.4477 13 11Z" fill="#020308" fill-opacity="0.64"/>
<path d="M17 11C17 11.5523 16.5523 12 16 12C15.4477 12 15 11.5523 15 11C15 10.4477 15.4477 10 16 10C16.5523 10 17 10.4477 17 11Z" fill="#020308" fill-opacity="0.64"/>
</svg>
'
];
?>

<section class="tabs-lamkadeh">
	<div class="tabs-lamkadeh-title">
		<div class="tabs-lamkadeh-title-wrapper">
			<img src="<?php echo esc_url($site_logo); ?>"
				height="<?php echo esc_attr($logo_height ?: 'auto'); ?>"
				width="<?php echo esc_attr($logo_width ?: 'auto'); ?>"
				alt="<?php bloginfo('name'); ?>">
			<div class="tabs-lamkadeh-title-text">
				<strong><?php echo esc_html($site_text_one); ?></strong>
				<span><?php echo esc_html($site_text_two); ?></span>
			</div>
		</div>
	</div>

	<div class="tabs-lamkadeh-items">
		<?php $i = 0;
		foreach ($product_tabs as $key => $tab) : $i++; ?>
			<a href="#tab-<?php echo esc_attr($key); ?>" class="tabs-lamkadeh-item <?php echo $i === 1 ? 'active' : ''; ?>">
				<span class="tab-icon">
					<?php echo isset($icons[$key]) ? $icons[$key] : ''; ?>
				</span>
				<div class="tabs-lamkadeh-item-rectangle"></div>
				<span class="tab-text"><?php echo wp_kses_post($tab['title']); ?></span>
			</a>
			<div class="tabs-lamkadeh-line"></div>
		<?php endforeach; ?>
	</div>
</section>

<section class="content-single-product-lamkadeh container">
	<div class="tabs-lamkadeh-content">
		<?php $i = 0;
		foreach ($product_tabs as $key => $tab) : $i++;
			$is_active = ($i === 1) ? 'active' : ''; ?>
			<div class="tabs-lamkadeh-panel <?php echo esc_attr($is_active); ?>" id="tab-<?php echo esc_attr($key); ?>">
				<?php if (isset($tab['callback']) && is_callable($tab['callback'])) {
					call_user_func($tab['callback'], $key, $tab);
				} ?>
			</div>
		<?php endforeach; ?>
	</div>
	<div class="sticky-single-product-lamkadeh">
		<div class="single-product-lamkadeh-item-header">
			<?php
			if (has_post_thumbnail($product->get_id())) {
				echo get_the_post_thumbnail($product->get_id(), 'woocommerce_single', array('class' => ''));
			}
			?>
			<div class="single-product-lamkadeh-item-header-button">
				<?php
				if (is_user_logged_in()) :
					$user_id = get_current_user_id();
					$wishlist = get_user_meta($user_id, 'lamkadeh_wishlist', true);
					$is_favorite = is_array($wishlist) && in_array($product->get_id(), $wishlist);
				?>
					<div class="single-product-lamkadeh-item-header-button-item lamkadeh-wishlist-btn wishlist-btn <?php echo $is_favorite ? 'active' : ''; ?>" data-product-id="<?php echo esc_attr($product->get_id()); ?>">
						<svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
							<path fill-rule="evenodd" clip-rule="evenodd" d="M4.21827 3.31808C2.97403 3.88683 2.0625 5.23961 2.0625 6.85276C2.0625 8.50081 2.73691 9.77111 3.70371 10.8598C4.50054 11.757 5.46513 12.5007 6.40584 13.2259C6.62928 13.3981 6.85136 13.5694 7.06953 13.7413C7.46406 14.0524 7.81599 14.3253 8.15521 14.5236C8.49461 14.7219 8.7678 14.8124 9 14.8124C9.2322 14.8124 9.50539 14.7219 9.84479 14.5236C10.184 14.3253 10.5359 14.0524 10.9305 13.7413C11.1486 13.5694 11.3707 13.3981 11.5942 13.2259C12.5349 12.5007 13.4995 11.757 14.2963 10.8598C15.2631 9.77111 15.9375 8.50081 15.9375 6.85276C15.9375 5.23961 15.026 3.88683 13.7817 3.31808C12.5729 2.76554 10.9488 2.91187 9.40527 4.51548C9.29923 4.62566 9.15291 4.68791 9 4.68791C8.84709 4.68791 8.70077 4.62566 8.59473 4.51548C7.05125 2.91187 5.42705 2.76554 4.21827 3.31808ZM9 3.34404C7.26596 1.79261 5.32422 1.57559 3.75057 2.2949C2.08853 3.05463 0.9375 4.81871 0.9375 6.85276C0.9375 8.85191 1.77037 10.377 2.86254 11.6068C3.73715 12.5916 4.80767 13.4159 5.75312 14.1439C5.96744 14.3089 6.17533 14.469 6.37306 14.6248C6.75724 14.9277 7.16966 15.2506 7.58762 15.4949C8.00539 15.739 8.4822 15.9374 9 15.9374C9.5178 15.9374 9.99461 15.739 10.4124 15.4949C10.8303 15.2506 11.2428 14.9277 11.6269 14.6248C11.8247 14.469 12.0326 14.3089 12.2469 14.1439C13.1923 13.4159 14.2628 12.5916 15.1375 11.6068C16.2296 10.377 17.0625 8.85191 17.0625 6.85276C17.0625 4.81871 15.9115 3.05463 14.2494 2.2949C12.6758 1.57559 10.734 1.79261 9 3.34404Z" fill="#1D2977" />
						</svg>
					</div>
				<?php else : ?>
					<div class="single-product-lamkadeh-item-header-button-item" onclick="loginBeforeWhishlist()">
						<svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
							<path fill-rule="evenodd" clip-rule="evenodd" d="M4.21827 3.31808C2.97403 3.88683 2.0625 5.23961 2.0625 6.85276C2.0625 8.50081 2.73691 9.77111 3.70371 10.8598C4.50054 11.757 5.46513 12.5007 6.40584 13.2259C6.62928 13.3981 6.85136 13.5694 7.06953 13.7413C7.46406 14.0524 7.81599 14.3253 8.15521 14.5236C8.49461 14.7219 8.7678 14.8124 9 14.8124C9.2322 14.8124 9.50539 14.7219 9.84479 14.5236C10.184 14.3253 10.5359 14.0524 10.9305 13.7413C11.1486 13.5694 11.3707 13.3981 11.5942 13.2259C12.5349 12.5007 13.4995 11.757 14.2963 10.8598C15.2631 9.77111 15.9375 8.50081 15.9375 6.85276C15.9375 5.23961 15.026 3.88683 13.7817 3.31808C12.5729 2.76554 10.9488 2.91187 9.40527 4.51548C9.29923 4.62566 9.15291 4.68791 9 4.68791C8.84709 4.68791 8.70077 4.62566 8.59473 4.51548C7.05125 2.91187 5.42705 2.76554 4.21827 3.31808ZM9 3.34404C7.26596 1.79261 5.32422 1.57559 3.75057 2.2949C2.08853 3.05463 0.9375 4.81871 0.9375 6.85276C0.9375 8.85191 1.77037 10.377 2.86254 11.6068C3.73715 12.5916 4.80767 13.4159 5.75312 14.1439C5.96744 14.3089 6.17533 14.469 6.37306 14.6248C6.75724 14.9277 7.16966 15.2506 7.58762 15.4949C8.00539 15.739 8.4822 15.9374 9 15.9374C9.5178 15.9374 9.99461 15.739 10.4124 15.4949C10.8303 15.2506 11.2428 14.9277 11.6269 14.6248C11.8247 14.469 12.0326 14.3089 12.2469 14.1439C13.1923 13.4159 14.2628 12.5916 15.1375 11.6068C16.2296 10.377 17.0625 8.85191 17.0625 6.85276C17.0625 4.81871 15.9115 3.05463 14.2494 2.2949C12.6758 1.57559 10.734 1.79261 9 3.34404Z" fill="#1D2977" />
						</svg>
					</div>
				<?php endif; ?>
				<div class="single-product-lamkadeh-item-header-button-item shareProductBtnTwo">
					<svg width="18" height="18" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path fill-rule="evenodd" clip-rule="evenodd" d="M16.5 2.25C14.7051 2.25 13.25 3.70507 13.25 5.5C13.25 5.69591 13.2673 5.88776 13.3006 6.07412L8.56991 9.38558C8.54587 9.4024 8.52312 9.42038 8.50168 9.43939C7.94993 9.00747 7.25503 8.75 6.5 8.75C4.70507 8.75 3.25 10.2051 3.25 12C3.25 13.7949 4.70507 15.25 6.5 15.25C7.25503 15.25 7.94993 14.9925 8.50168 14.5606C8.52312 14.5796 8.54587 14.5976 8.56991 14.6144L13.3006 17.9259C13.2673 18.1122 13.25 18.3041 13.25 18.5C13.25 20.2949 14.7051 21.75 16.5 21.75C18.2949 21.75 19.75 20.2949 19.75 18.5C19.75 16.7051 18.2949 15.25 16.5 15.25C15.4472 15.25 14.5113 15.7506 13.9174 16.5267L9.43806 13.3911C9.63809 12.9694 9.75 12.4978 9.75 12C9.75 11.5022 9.63809 11.0306 9.43806 10.6089L13.9174 7.4733C14.5113 8.24942 15.4472 8.75 16.5 8.75C18.2949 8.75 19.75 7.29493 19.75 5.5C19.75 3.70507 18.2949 2.25 16.5 2.25ZM14.75 5.5C14.75 4.5335 15.5335 3.75 16.5 3.75C17.4665 3.75 18.25 4.5335 18.25 5.5C18.25 6.4665 17.4665 7.25 16.5 7.25C15.5335 7.25 14.75 6.4665 14.75 5.5ZM6.5 10.25C5.5335 10.25 4.75 11.0335 4.75 12C4.75 12.9665 5.5335 13.75 6.5 13.75C7.4665 13.75 8.25 12.9665 8.25 12C8.25 11.0335 7.4665 10.25 6.5 10.25ZM16.5 16.75C15.5335 16.75 14.75 17.5335 14.75 18.5C14.75 19.4665 15.5335 20.25 16.5 20.25C17.4665 20.25 18.25 19.4665 18.25 18.5C18.25 17.5335 17.4665 16.75 16.5 16.75Z" fill="#1D2977" />
					</svg>
				</div>
			</div>
		</div>
		<div class="single-product-lamkadeh-item-bottom">
			<div class="single-product-lamkadeh-item-bottom-header">

				<div class="single-product-lamkadeh-item-bottom-header-name">
					<div class="single-product-lamkadeh-item-bottom-header-category">
						<?php
						global $product;

						$categories = get_the_terms($product->get_id(), 'product_cat');

						if ($categories && !is_wp_error($categories)) {
							$main_category = null;
							foreach ($categories as $category) {
								if ($category->parent == 0) {
									$main_category = $category;
									break;
								}
							}

							if (!$main_category) {
								$main_category = reset($categories);
							}

							if ($main_category) {
								$thumbnail_id = get_term_meta($main_category->term_id, 'thumbnail_id', true);
								$image_url = $thumbnail_id
									? wp_get_attachment_image_url($thumbnail_id, 'thumbnail')
									: wc_placeholder_img_src();
						?>
								<a href="<?php echo esc_url(get_term_link($main_category)) ?>" target="_blank" rel="follow" class="single-product-lamkadeh-item-bottom-header-category-name">

									<img src="<?php echo esc_url($image_url) ?>" alt="<?php echo esc_attr($main_category->name) ?>">
									<span><?php echo esc_html($main_category->name) ?></span>
								</a>
						<?php
							}
						}
						?>
						<?php
						if ($product && is_a($product, 'WC_Product')) {

							$is_in_stock = $product->is_in_stock();

							$stock_class = $is_in_stock ? 'in-stock' : 'out-of-stock';
							$stock_text  = $is_in_stock ? __('موجود در انبار', 'lamkadeh') : __('ناموجود در انبار', 'lamkadeh');
							$stock_color = $is_in_stock ? '#02734C' : '#CC0000';
						?>

							<div class="single-product-lamkadeh-item-bottom-header-category-stock <?php echo esc_attr($stock_class); ?>">
								<svg width="16" height="16" viewBox="0 0 16 16" fill="none"
									xmlns="http://www.w3.org/2000/svg">
									<g clip-path="url(#clip0_1_11360)">
										<?php if ($is_in_stock) : ?>
											<path d="M10.6866 6.68693C10.8818 6.49167 10.8818 6.17508 10.6866 5.97982C10.4913 5.78456 10.1747 5.78456 9.97945 5.97982L6.99968 8.9596L6.01989 7.97982C5.82463 7.78456 5.50805 7.78456 5.31279 7.97982C5.11753 8.17508 5.11753 8.49167 5.31279 8.68693L6.64612 10.0203C6.84138 10.2155 7.15797 10.2155 7.35323 10.0203L10.6866 6.68693Z" fill="<?php echo esc_attr($stock_color); ?>" />
											<path fill-rule="evenodd" clip-rule="evenodd" d="M7.99967 0.833373C4.04163 0.833374 0.833008 4.042 0.833008 8.00004C0.833009 11.9581 4.04164 15.1667 7.99968 15.1667C11.9577 15.1667 15.1663 11.9581 15.1663 8.00004C15.1663 4.042 11.9577 0.833373 7.99967 0.833373ZM1.83301 8.00004C1.83301 4.59429 4.59392 1.83337 7.99967 1.83337C11.4054 1.83337 14.1663 4.59428 14.1663 8.00004C14.1663 11.4058 11.4054 14.1667 7.99968 14.1667C4.59392 14.1667 1.83301 11.4058 1.83301 8.00004Z" fill="<?php echo esc_attr($stock_color); ?>" />
										<?php else : ?>
											<path d="M5.5 5.5L10.5 10.5M10.5 5.5L5.5 10.5" stroke="<?php echo esc_attr($stock_color); ?>" stroke-width="1.2" stroke-linecap="round" />
											<circle cx="8" cy="8" r="7.2" stroke="<?php echo esc_attr($stock_color); ?>" stroke-width="1.2" />
										<?php endif; ?>
									</g>
									<defs>
										<clipPath id="clip0_1_11360">
											<rect width="16" height="16" fill="white" />
										</clipPath>
									</defs>
								</svg>
								<span><?php echo esc_html($stock_text); ?></span>
							</div>

						<?php } ?>
					</div>
					<span class="single-product-lamkadeh-item-bottom-header-name-title"><?php echo the_title() ?></span>
				</div>

				<div class="underline-lamkadeh">
					<div class="underline-lamkadeh-line"></div>
					<div class="underline-lamkadeh-circle"></div>
				</div>
				<?php
				// تابع فرمت عدد قیمت
				function lamkadeh_format_price($price)
				{
					return number_format(floatval($price), 0, '.', ',');
				}

				// مقداردهی اولیه
				$regular_price = floatval($product->get_regular_price());
				$sale_price = floatval($product->get_sale_price());
				$discount_percent = 0;

				// بررسی نوع محصول
				if ($product->is_type('variable')) {
					$prices = $product->get_variation_prices(true);
					$max_regular = !empty($prices['regular_price']) ? max($prices['regular_price']) : 0;
					$min_sale = !empty($prices['sale_price']) ? min($prices['sale_price']) : 0;

					if ($min_sale && $min_sale < $max_regular) {
						$discount_percent = round((($max_regular - $min_sale) / $max_regular) * 100);
					}

					$display_regular = $max_regular;
					$display_sale = $min_sale ? $min_sale : $max_regular;
				} else {
					$display_regular = $regular_price;
					$display_sale = $sale_price ? $sale_price : $regular_price;

					if ($sale_price && $sale_price < $regular_price) {
						$discount_percent = round((($regular_price - $sale_price) / $regular_price) * 100);
					}
				}
				?>

				<div class="single-product-lamkadeh-item-bottom-header-price" data-product-id="<?php echo esc_attr($product->get_id()); ?>">

					<?php if ($discount_percent > 0): ?>
						<div class="single-product-lamkadeh-item-bottom-header-price-regular">
							<div class="single-product-lamkadeh-item-bottom-header-price-regular-number">
								<?php echo lamkadeh_format_price($display_regular); ?>
							</div>
							<div class="single-product-lamkadeh-item-bottom-header-price-regular-discount">
								%<?php echo esc_html($discount_percent); ?>
							</div>
						</div>
					<?php endif; ?>

					<div class="single-product-lamkadeh-item-bottom-header-price-sales-off">
						<div class="single-product-lamkadeh-item-bottom-header-price-sales-off-shape"></div>
						<span class="single-product-lamkadeh-item-bottom-header-price-sales-off-number">
							<?php echo lamkadeh_format_price($display_sale); ?>
						</span>
						<span class="single-product-lamkadeh-item-bottom-header-price-sales-off-symbol">تومان</span>
					</div>
				</div>

				<?php if ($product->is_type('variable')): ?>
					<script>
						document.addEventListener('DOMContentLoaded', function() {
							const wrapper = document.querySelector('.single-product-lamkadeh-item-bottom-header-price');
							const form = document.querySelector('form.variations_form');

							if (form && wrapper) {
								jQuery(form).on('found_variation', function(event, variation) {
									const regular = variation.display_regular_price;
									const sale = variation.display_price;
									const discount = regular > sale ? Math.round(((regular - sale) / regular) * 100) : 0;

									const regularBox = wrapper.querySelector('.single-product-lamkadeh-item-bottom-header-price-regular');
									const regularNumber = wrapper.querySelector('.single-product-lamkadeh-item-bottom-header-price-regular-number');
									const discountEl = wrapper.querySelector('.single-product-lamkadeh-item-bottom-header-price-regular-discount');
									const saleNumber = wrapper.querySelector('.single-product-lamkadeh-item-bottom-header-price-sales-off-number');

									if (discount > 0) {
										regularBox.style.display = 'flex';
										regularNumber.textContent = regular.toLocaleString();
										discountEl.textContent = '%' + discount;
									} else {
										regularBox.style.display = 'none';
									}

									saleNumber.textContent = sale.toLocaleString();
								});

								jQuery(form).on('reset_data', function() {
									const regularBox = wrapper.querySelector('.single-product-lamkadeh-item-bottom-header-price-regular');
									const regularNumber = wrapper.querySelector('.single-product-lamkadeh-item-bottom-header-price-regular-number');
									const discountEl = wrapper.querySelector('.single-product-lamkadeh-item-bottom-header-price-regular-discount');
									const saleNumber = wrapper.querySelector('.single-product-lamkadeh-item-bottom-header-price-sales-off-number');

									<?php if ($discount_percent > 0): ?>
										regularBox.style.display = 'flex';
										regularNumber.textContent = '<?php echo lamkadeh_format_price($display_regular); ?>';
										discountEl.textContent = '%<?php echo $discount_percent; ?>';
									<?php else: ?>
										regularBox.style.display = 'none';
									<?php endif; ?>

									saleNumber.textContent = '<?php echo lamkadeh_format_price($display_sale); ?>';
								});
							}
						});
					</script>
				<?php endif; ?>

				<div class="underline-lamkadeh">
					<div class="underline-lamkadeh-line"></div>
					<div class="underline-lamkadeh-circle"></div>
				</div>
			</div>
			<a href="#add-to-cart-sticky" class="single-product-lamkadeh-item-bottom-body">
				<div class="single-product-lamkadeh-item-bottom-body-right"><?php echo __("افزودن به سبد خرید", "lamkadeh") ?></div>
				<div class="single-product-lamkadeh-item-bottom-body-left">
					<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path fill-rule="evenodd" clip-rule="evenodd" d="M11.9996 2.75C10.7569 2.75 9.74958 3.75736 9.74958 5V5.25447C10.1671 5.24999 10.6178 5.25 11.1048 5.25H12.8943C13.3814 5.25 13.8321 5.24999 14.2496 5.25447V5C14.2496 3.75736 13.2422 2.75 11.9996 2.75ZM15.7496 5.30694V5C15.7496 2.92893 14.0706 1.25 11.9996 1.25C9.92851 1.25 8.24958 2.92893 8.24958 5V5.30694C8.11458 5.31679 7.9843 5.32834 7.85855 5.34189C6.98019 5.43657 6.24565 5.63489 5.59336 6.08197C5.36901 6.23574 5.15829 6.40849 4.96351 6.59833C4.39718 7.15027 4.05865 7.83166 3.79356 8.67439C3.53619 9.49258 3.32818 10.5327 3.0668 11.8396L3.04773 11.935C2.67109 13.8181 2.37429 15.302 2.28905 16.484C2.20195 17.6916 2.32366 18.7075 2.8957 19.588C3.08656 19.8817 3.30933 20.1534 3.55995 20.3982C4.31108 21.1318 5.28343 21.4504 6.48469 21.6018C7.66038 21.75 9.17369 21.75 11.0941 21.75H12.905C14.8255 21.75 16.3388 21.75 17.5145 21.6018C18.7157 21.4504 19.6881 21.1318 20.4392 20.3982C20.6898 20.1534 20.9126 19.8817 21.1035 19.588C21.6755 18.7075 21.7972 17.6916 21.7101 16.484C21.6249 15.3021 21.3281 13.8182 20.9514 11.9351L20.9324 11.8396C20.671 10.5327 20.463 9.49259 20.2056 8.67439C19.9405 7.83166 19.602 7.15027 19.0356 6.59833C18.8409 6.40849 18.6301 6.23574 18.4058 6.08197C17.7535 5.63489 17.019 5.43657 16.1406 5.34189C16.0148 5.32834 15.8846 5.31679 15.7496 5.30694ZM8.01929 6.83326C7.27258 6.91374 6.81128 7.06572 6.44139 7.31924C6.28789 7.42445 6.14371 7.54265 6.01044 7.67254C5.6893 7.98552 5.4498 8.40807 5.22444 9.12449C4.99414 9.85661 4.80098 10.8172 4.52919 12.1762C4.13964 14.1239 3.86281 15.5153 3.78516 16.5919C3.70858 17.6538 3.83789 18.2849 4.15352 18.7707C4.28411 18.9717 4.43653 19.1576 4.608 19.3251C5.02245 19.7298 5.61597 19.9804 6.6723 20.1136C7.74319 20.2486 9.16181 20.25 11.1481 20.25H12.851C14.8373 20.25 16.256 20.2486 17.3269 20.1136C18.3832 19.9804 18.9767 19.7298 19.3911 19.3251C19.5626 19.1576 19.715 18.9717 19.8456 18.7707C20.1613 18.2849 20.2906 17.6538 20.214 16.5919C20.1363 15.5153 19.8595 14.1239 19.47 12.1762C19.1982 10.8173 19.005 9.85661 18.7747 9.12449C18.5494 8.40807 18.3099 7.98552 17.9887 7.67254C17.8554 7.54265 17.7113 7.42445 17.5578 7.31924C17.1879 7.06572 16.7266 6.91374 15.9799 6.83326C15.2168 6.75101 14.2369 6.75 12.851 6.75H11.1481C9.76223 6.75 8.78236 6.75101 8.01929 6.83326ZM8.92054 14.2929C9.31108 14.1548 9.73957 14.3595 9.8776 14.7501C10.1868 15.625 11.0213 16.25 11.9998 16.25C12.9783 16.25 13.8127 15.625 14.1219 14.7501C14.26 14.3595 14.6885 14.1548 15.079 14.2929C15.4695 14.4309 15.6742 14.8594 15.5362 15.2499C15.0218 16.7054 13.6337 17.75 11.9998 17.75C10.3658 17.75 8.97778 16.7054 8.46334 15.2499C8.32531 14.8594 8.53 14.4309 8.92054 14.2929Z" fill="white" />
					</svg>
				</div>
			</a>
		</div>
	</div>
</section>

<script>
	const section = document.querySelector('.sticky-single-product-lamkadeh');
	const primary = document.querySelector('.content-single-product-lamkadeh');
	if (section && primary) {
		primary.appendChild(section);
	}

	document.addEventListener('DOMContentLoaded', function() {
		const tabs = document.querySelectorAll('.tabs-lamkadeh-item');
		tabs.forEach(tab => {
			tab.addEventListener('click', e => {
				tabs.forEach(t => t.classList.remove('active'));
				tab.classList.add('active');

				const target = document.querySelector(tab.getAttribute('href'));
				if (target) {
					e.preventDefault();
					window.scrollTo({
						top: target.offsetTop - 0,
						behavior: 'smooth'
					});
				}
			});
		});
	});
</script>