<?php

/**
 * Additional Information tab
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/tabs/additional-information.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.0.0
 */

defined('ABSPATH') || exit;

global $product;

$heading = apply_filters('woocommerce_product_additional_information_heading', __('مشخصات محصــــــــــول', 'lamkadeh'));

$attributes = $product->get_attributes();

if (!$attributes) {
	return;
}

?>
<div class="title-description-single-product">
	<div class="title-description-single-product-main">
		<span class="title-description-single-product-subtitle">SEPIFICATION</span>
		<div class="title-description-single-product-content">
			<?php if ($heading) : ?>
				<span><?php echo esc_html($heading); ?></span>
			<?php endif; ?>
			<svg width="64" height="64" viewBox="0 0 64 64" fill="none" xmlns="http://www.w3.org/2000/svg">
				<g clip-path="url(#clip0_1_11397)">
					<circle cx="32" cy="32" r="32" transform="matrix(-1 0 0 1 64 0)" fill="#FFD701" />
					<path fill-rule="evenodd" clip-rule="evenodd" d="M49.817 20.5089C49.4772 19.9205 48.8545 19.727 48.2601 19.6439C47.6609 19.5601 46.8589 19.5601 45.8889 19.5602L45.8337 19.5602C45.2561 19.5602 44.8784 19.5545 44.6033 19.5162C44.3545 19.4816 44.2754 19.4304 44.2416 19.4006C44.2169 19.3748 44.1729 19.3145 44.1429 19.0973C44.1075 18.8412 44.106 18.49 44.106 17.9271V17.5838C44.106 16.1286 44.106 14.9628 43.994 14.1317C43.8889 13.3515 43.639 12.4753 42.7735 12.2101C41.9232 11.9495 41.21 12.5083 40.6556 13.0843C40.0651 13.698 39.3636 14.6472 38.4853 15.8356L35.6097 19.7262C35.0502 20.4831 34.5838 21.1141 34.3059 21.6358C34.0274 22.1588 33.8246 22.7798 34.1336 23.3993L34.1347 23.4016L34.138 23.4083L34.1417 23.4156L34.1453 23.4226L34.1493 23.4301L34.1533 23.4376L34.1572 23.4445L34.1612 23.4516L34.1649 23.4579L34.1663 23.4602C34.5032 24.0436 35.1232 24.2479 35.723 24.3394C36.3411 24.4338 37.1659 24.4399 38.1663 24.4399C38.7498 24.4399 39.1219 24.4412 39.3952 24.476C39.6366 24.5068 39.7088 24.5542 39.7397 24.5816C39.7671 24.6102 39.8152 24.6771 39.8491 24.9022C39.8879 25.1598 39.894 25.5165 39.894 26.073L39.894 26.4161C39.8939 27.8714 39.8939 29.0371 40.0059 29.8683C40.111 30.6484 40.3609 31.5246 41.2264 31.7899C42.0767 32.0505 42.7899 31.4917 43.3442 30.9157C43.9348 30.302 44.6363 29.3528 45.5147 28.1644L48.3558 24.3205C48.934 23.5382 49.4095 22.8846 49.69 22.3406C49.9644 21.8083 50.1559 21.1837 49.8498 20.5698L49.8487 20.5676L49.8454 20.5609L49.8417 20.5536L49.8381 20.5465L49.8341 20.539L49.83 20.5315L49.8261 20.5246L49.8221 20.5175L49.8183 20.5111L49.817 20.5089ZM41.6464 14.0378C41.1258 14.5788 40.477 15.4541 39.5569 16.699L36.7499 20.4968C36.147 21.3125 35.7437 21.8613 35.5195 22.2822C35.4104 22.487 35.3695 22.6162 35.3578 22.6945C35.3506 22.7428 35.355 22.7646 35.3608 22.7786C35.3829 22.8112 35.4792 22.9113 35.9305 22.9802C36.4236 23.0555 37.1326 23.0649 38.1663 23.0649L38.2084 23.0649C38.7374 23.0648 39.1984 23.0648 39.5691 23.1121C39.9662 23.1627 40.3606 23.2778 40.6872 23.585L40.6925 23.59L40.6977 23.5951C41.0186 23.9101 41.149 24.3005 41.2088 24.6975C41.2659 25.0768 41.269 25.5435 41.269 26.073L41.269 26.3568C41.269 27.8848 41.2705 28.9568 41.3686 29.6847C41.4174 30.0471 41.4831 30.2597 41.546 30.3785C41.5931 30.4674 41.6203 30.4733 41.6279 30.4749L41.6293 30.4752L41.6307 30.4757C41.6403 30.479 41.674 30.4907 41.7782 30.4382C41.9084 30.3727 42.0944 30.2315 42.3535 29.9622C42.8741 29.4212 43.5229 28.5459 44.443 27.301L47.25 23.5032C47.8495 22.6922 48.2489 22.1353 48.4679 21.7106C48.6555 21.3465 48.6351 21.2232 48.6226 21.1905C48.602 21.1604 48.5096 21.0672 48.0697 21.0056C47.5773 20.9368 46.8728 20.9352 45.8337 20.9352C45.2811 20.9352 44.8018 20.932 44.414 20.8781C44.0135 20.8224 43.6182 20.7019 43.2944 20.3974L43.2891 20.3924L43.2839 20.3873C42.9601 20.0695 42.8352 19.6795 42.7808 19.2854C42.7309 18.924 42.7309 18.4763 42.731 17.9714L42.731 17.6432C42.731 16.1152 42.7294 15.0432 42.6313 14.3153C42.5825 13.9529 42.5168 13.7403 42.4539 13.6215C42.4067 13.5326 42.3796 13.5267 42.372 13.5251L42.3706 13.5248L42.3692 13.5243C42.3596 13.521 42.3258 13.5093 42.2216 13.5618C42.0915 13.6273 41.9055 13.7685 41.6464 14.0378Z" fill="#1D2977" />
					<circle cx="22" cy="60" r="17" fill="#F7F8FD" fill-opacity="0.64" />
				</g>
				<defs>
					<clipPath id="clip0_1_11397">
						<rect width="64" height="64" rx="32" fill="white" />
					</clipPath>
				</defs>
			</svg>

		</div>
		<div class="title-description-single-product-shape"></div>
	</div>
	<div class="title-description-single-product-text">
		<span>
			می‌خوای دقیق‌تر بدونی با چه <strong>مبلی طرفی؟</strong> اینجا همه <strong>جزئیات فنی و ویژگی‌های مهمش</strong> رو برات چیدیم!
		</span>
	</div>
</div>

<section class="lamkadeh-additional-info-content">
	<section class="description-single-product-lamkadeh-shape"></section>
	<section class="lamkadeh-additional-info-wrapper">
		<?php foreach ($attributes as $attribute) :
			$attribute_name = $attribute->get_name();
			$attribute_label = wc_attribute_label($attribute_name);
			$attribute_values = [];

			if ($attribute->is_taxonomy()) {
				$terms = wc_get_product_terms($product->get_id(), $attribute_name, ['fields' => 'all']);
				foreach ($terms as $term) {
					$attribute_values[] = esc_html($term->name);
				}
			} else {
				$attribute_values = $attribute->get_options();
			}
		?>
			<div class="lamkadeh-additional-info-item">
				<div class="lamkadeh-additional-info-item-attribute-name">
					<span class="counter-attribute-name"></span>
					<div class="underline-lamkadeh">
						<div class="underline-lamkadeh-line"></div>
						<div class="underline-lamkadeh-circle"></div>
					</div>
					<span class="attribute-name"><?php echo esc_html($attribute_label); ?></span>
				</div>
				<strong>:</strong>
				<div class="lamkadeh-additional-info-item-attribute-value">
					<span>
						<?php
						if ($attribute_name === 'pa_color' || $attribute_name === 'color') {
							$values = [];
							if ($attribute->is_taxonomy()) {
								$terms = wp_get_post_terms($product->get_id(), $attribute->get_name(), ['fields' => 'all']);
								foreach ($terms as $term) {
									$values[] = esc_html($term->name);
								}
							} else {
								$options = $attribute->get_options();
								foreach ($options as $value) {
									$values[] = esc_html($value);
								}
							}
							echo implode('، ', $values);
						} else {
							$values = [];
							if ($attribute->is_taxonomy()) {
								$terms = wp_get_post_terms($product->get_id(), $attribute->get_name(), ['fields' => 'all']);
								foreach ($terms as $term) {
									$values[] = esc_html($term->name);
								}
							} else {
								$options = $attribute->get_options();
								foreach ($options as $value) {
									$values[] = esc_html($value);
								}
							}
							echo implode('، ', $values);
						}
						?>
					</span>
				</div>
			</div>
		<?php endforeach; ?>

		<?php
		$length = $product->get_length();
		$width  = $product->get_width();
		$height = $product->get_height();
		$weight = $product->get_weight();

		$dimension_unit = get_option('woocommerce_dimension_unit');
		$weight_unit    = get_option('woocommerce_weight_unit');

		if ($dimension_unit === "cm") {
			$dimension_unit = __("سانتی‌متر", "lamkdeh");
		}
		if ($weight_unit === "kg") {
			$weight_unit = __("کیلوگرم", "lamkadeh");
		}

		if ($length || $width || $height || $weight) :
		?>
			<div class="lamkadeh-additional-info-item dimensions-single-product">
				<div class="lamkadeh-additional-info-item-attribute-name">
					<span class="counter-attribute-name"></span>
					<div class="underline-lamkadeh">
						<div class="underline-lamkadeh-line"></div>
						<div class="underline-lamkadeh-circle"></div>
					</div>
					<span class="attribute-name"><?php echo __("ابعاد", "lamkadeh"); ?></span>
				</div>
				<strong>:</strong>
				<div class="lamkadeh-additional-info-item-attribute-value">
					<span>

						<?php if ($length) : ?>
							<span>
								طول: <?php echo esc_html($length . ' ' . $dimension_unit); ?>
							</span>
						<?php endif; ?>


						<?php if ($width) : ?>
							<span>
								عرض: <?php echo esc_html($width . ' ' . $dimension_unit); ?>
							</span>
						<?php endif; ?>

						<?php if ($height) : ?>
							<span>
								ارتفاع: <?php echo esc_html($height . ' ' . $dimension_unit); ?>
							</span>
						<?php endif; ?>

						<?php if ($weight) : ?>
							<span>
								وزن: <?php echo esc_html($weight . ' ' . $weight_unit); ?>
							</span>
						<?php endif; ?>
					</span>
				</div>
			</div>
		<?php endif; ?>
		<div class="fade-overlay"></div>
	</section>
	<button class="more-additional-info-single-product-lamkadeh">
		<?php echo __("مشاهده بیشتر", "lamkadeh") ?>
		<svg width="18" height="18" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M3.69247 7.09327C3.91711 6.83119 4.31167 6.80084 4.57375 7.02548L10.0003 11.6768L15.4269 7.02548C15.689 6.80084 16.0836 6.83119 16.3082 7.09327C16.5328 7.35535 16.5025 7.74991 16.2404 7.97455L10.4071 12.9745C10.173 13.1752 9.82765 13.1752 9.59359 12.9745L3.76026 7.97455C3.49818 7.74991 3.46783 7.35535 3.69247 7.09327Z" fill="#1D2977" />
		</svg>
	</button>
</section>

<script>
	document.addEventListener("DOMContentLoaded", function() {
		const wrapper = document.querySelector(".lamkadeh-additional-info-wrapper");
		const button = document.querySelector(".more-additional-info-single-product-lamkadeh");
		const icon = button.querySelector("svg");
		const text = button.firstChild;

		if (wrapper && button) {
			button.addEventListener("click", function() {
				wrapper.classList.toggle("expanded");

				if (wrapper.classList.contains("expanded")) {
					text.textContent = "<?php echo __('نمایش کمتر', 'lamkadeh'); ?> ";
					icon.style.transform = "rotate(180deg)";
				} else {
					text.textContent = "<?php echo __('مشاهده بیشتر', 'lamkadeh'); ?> ";
					icon.style.transform = "rotate(0deg)";
				}
			});
		}
	});
</script>