<?php

/**
 * Single Product Price
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/price.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.0.0
 */

if (!defined('ABSPATH')) exit;

global $product;

function lamkadeh_clean_price($price)
{
	$price = floatval($price);
	return number_format($price, 0, '.', ',');
}

$regular_price = floatval($product->get_regular_price());
$sale_price    = floatval($product->get_sale_price());
$discount_percent = 0;

if ($product->is_type('variable')) {
	$prices = $product->get_variation_prices(true);
	if (!empty($prices['regular_price'])) {
		$max_regular = max($prices['regular_price']);
	}
	if (!empty($prices['sale_price'])) {
		$max_sale = max($prices['sale_price']);
	}

	if (!empty($max_sale) && $max_sale < $max_regular) {
		$discount_percent = round((($max_regular - $max_sale) / $max_regular) * 100);
	}

	$display_regular = $max_regular;
	$display_sale    = $max_sale ? $max_sale : $max_regular;
} else {
	$display_regular = $regular_price;
	$display_sale    = $sale_price ? $sale_price : $regular_price;

	if ($sale_price && $sale_price < $regular_price) {
		$discount_percent = round((($regular_price - $sale_price) / $regular_price) * 100);
	}
}
?>

<div class="amount-price-lamkadeh" data-product-id="<?php echo esc_attr($product->get_id()); ?>">

	<?php if ($discount_percent > 0): ?>
		<div class="amount-price-lamkadeh-regular">
			<span class="amount-price-lamkadeh-regular-underline">
				<?php echo lamkadeh_clean_price($display_regular); ?>
			</span>
			<span class="amount-price-lamkadeh-regular-badge">٪<?php echo esc_html($discount_percent); ?></span>
		</div>
	<?php endif; ?>

	<div class="amount-price-lamkadeh-salesoff">
		<span class="amount-price-lamkadeh-salesoff-sale">
			<?php echo lamkadeh_clean_price($display_sale); ?>
		</span>
		<span class="amount-price-lamkadeh-salesoff-symbol">تــــــو مــان</span>
		<div class="amount-price-lamkadeh-salesoff-rectangle"></div>
	</div>
</div>

<?php if ($product->is_type('variable')): ?>
	<script>
		document.addEventListener('DOMContentLoaded', function() {
			const priceWrapper = document.querySelector('.amount-price-lamkadeh');
			const form = document.querySelector('form.variations_form');

			if (form && priceWrapper) {
				jQuery(form).on('found_variation', function(event, variation) {
					const regular = variation.display_regular_price;
					const sale = variation.display_price;
					const discount = variation.display_regular_price > variation.display_price ?
						Math.round(((variation.display_regular_price - variation.display_price) / variation.display_regular_price) * 100) :
						0;

					if (discount > 0) {
						priceWrapper.querySelector('.amount-price-lamkadeh-regular-underline').textContent = regular.toLocaleString();
						priceWrapper.querySelector('.amount-price-lamkadeh-regular-badge').textContent = '٪' + discount;
						priceWrapper.querySelector('.amount-price-lamkadeh-regular').style.display = 'flex';
					} else {
						priceWrapper.querySelector('.amount-price-lamkadeh-regular').style.display = 'none';
					}

					priceWrapper.querySelector('.amount-price-lamkadeh-salesoff-sale').textContent = sale.toLocaleString();
				});

				jQuery(form).on('reset_data', function() {
					<?php if ($discount_percent > 0): ?>
						priceWrapper.querySelector('.amount-price-lamkadeh-regular-underline').textContent = '<?php echo lamkadeh_clean_price($display_regular); ?>';
						priceWrapper.querySelector('.amount-price-lamkadeh-regular-badge').textContent = '٪<?php echo $discount_percent; ?>';
						priceWrapper.querySelector('.amount-price-lamkadeh-regular').style.display = 'flex';
					<?php else: ?>
						priceWrapper.querySelector('.amount-price-lamkadeh-regular').style.display = 'none';
					<?php endif; ?>

					priceWrapper.querySelector('.amount-price-lamkadeh-salesoff-sale').textContent = '<?php echo lamkadeh_clean_price($display_sale); ?>';
				});
			}
		});
	</script>
<?php endif; ?>