<?php

/**
 * My Account Dashboard
 *
 * Shows the first intro screen on the account dashboard.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/dashboard.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 4.4.0
 */

if (! defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

$allowed_html = array(
	'a' => array(
		'href' => array(),
	),
);
?>

<section class="header-categories-main">
	<div class="title-header-categories-main">
		<span>DASHBOARD</span>
		<div class="text-header-categories-main">
			<span><?php echo __("<strong>داشبــــــــــــــورد</strong>", "lamkadeh") ?></span>
			<svg width="64" height="64" viewBox="0 0 64 64" fill="none" xmlns="http://www.w3.org/2000/svg">
				<g clip-path="url(#clip0_26_3865)">
					<circle cx="32" cy="32" r="32" transform="matrix(-1 0 0 1 64 0)" fill="#FFD701" />
					<path fill-rule="evenodd" clip-rule="evenodd" d="M42 10.2917C40.9644 10.2917 40.125 11.1311 40.125 12.1667V12.3787C40.4729 12.375 40.8485 12.375 41.2543 12.375H42.7456C43.1515 12.375 43.5271 12.375 43.875 12.3787V12.1667C43.875 11.1311 43.0355 10.2917 42 10.2917ZM45.125 12.4224V12.1667C45.125 10.4408 43.7259 9.04166 42 9.04166C40.2741 9.04166 38.875 10.4408 38.875 12.1667V12.4224C38.7625 12.4306 38.6539 12.4403 38.5491 12.4516C37.8172 12.5305 37.205 12.6957 36.6615 13.0683C36.4745 13.1964 36.2989 13.3404 36.1366 13.4986C35.6646 13.9586 35.3825 14.5264 35.1616 15.2286C34.9471 15.9105 34.7738 16.7772 34.556 17.8663L34.5401 17.9458C34.2262 19.5151 33.9789 20.7517 33.9079 21.7366C33.8353 22.743 33.9367 23.5896 34.4134 24.3233C34.5725 24.5681 34.7581 24.7945 34.9669 24.9985C35.5929 25.6098 36.4032 25.8753 37.4042 26.0015C38.384 26.125 39.6451 26.125 41.2454 26.125H42.7545C44.3549 26.125 45.616 26.125 46.5957 26.0015C47.5968 25.8753 48.4071 25.6098 49.033 24.9985C49.2418 24.7945 49.4275 24.5681 49.5865 24.3233C50.0632 23.5896 50.1647 22.743 50.0921 21.7366C50.021 20.7517 49.7737 19.5151 49.4599 17.9459L49.444 17.8663C49.2261 16.7772 49.0528 15.9105 48.8383 15.2286C48.6174 14.5264 48.3353 13.9586 47.8634 13.4986C47.701 13.3404 47.5254 13.1964 47.3385 13.0683C46.7949 12.6957 46.1828 12.5305 45.4508 12.4516C45.346 12.4403 45.2375 12.4306 45.125 12.4224ZM38.6831 13.6944C38.0608 13.7614 37.6764 13.8881 37.3682 14.0994C37.2402 14.187 37.1201 14.2855 37.009 14.3938C36.7414 14.6546 36.5418 15.0067 36.354 15.6037C36.1621 16.2138 36.0011 17.0144 35.7746 18.1468C35.45 19.7699 35.2193 20.9294 35.1546 21.8265C35.0908 22.7115 35.1986 23.2374 35.4616 23.6422C35.5704 23.8097 35.6974 23.9647 35.8403 24.1042C36.1857 24.4415 36.6803 24.6504 37.5606 24.7613C38.453 24.8738 39.6352 24.875 41.2904 24.875H42.7095C44.3648 24.875 45.547 24.8738 46.4394 24.7613C47.3196 24.6504 47.8142 24.4415 48.1596 24.1042C48.3025 23.9647 48.4295 23.8097 48.5384 23.6422C48.8014 23.2374 48.9091 22.7115 48.8453 21.8265C48.7806 20.9294 48.5499 19.7699 48.2253 18.1468C47.9988 17.0144 47.8378 16.2138 47.6459 15.6037C47.4581 15.0067 47.2585 14.6546 46.9909 14.3938C46.8799 14.2855 46.7597 14.187 46.6318 14.0994C46.3236 13.8881 45.9391 13.7614 45.3169 13.6944C44.681 13.6258 43.8644 13.625 42.7095 13.625L41.2904 13.625C40.1355 13.625 39.319 13.6258 38.6831 13.6944ZM39.4341 19.9107C39.7596 19.7957 40.1166 19.9663 40.2317 20.2917C40.4894 21.0208 41.1847 21.5417 42.0001 21.5417C42.8155 21.5417 43.5109 21.0208 43.7686 20.2917C43.8836 19.9663 44.2407 19.7957 44.5662 19.9107C44.8916 20.0257 45.0622 20.3828 44.9472 20.7083C44.5185 21.9212 43.3618 22.7917 42.0001 22.7917C40.6385 22.7917 39.4818 21.9212 39.0531 20.7083C38.9381 20.3828 39.1087 20.0257 39.4341 19.9107Z" fill="#1D2977" />
					<circle cx="22" cy="60" r="17" fill="#F7F8FD" fill-opacity="0.64" />
				</g>
				<defs>
					<clipPath id="clip0_26_3865">
						<rect width="64" height="64" rx="32" fill="white" />
					</clipPath>
				</defs>
			</svg>
		</div>
		<div class="shape-header-categories-main"></div>
	</div>
</section>

<section class="orders-dashboard">
	<div class="orders-dashboard-items">
		<?php
		if (is_user_logged_in()) {
			$current_user_id = get_current_user_id();

			// شمارش سفارش‌ها بر اساس وضعیت
			$statuses = [
				'processing' => __("سفارش های جاری", "lamakdeh"),
				'on-hold'    => __("سفارش های جاری", "lamakdeh"),
				'pending'    => __("سفارش های جاری", "lamakdeh"),
				'completed'  => __("سفارش های به اتمام رسیده", "lamakdeh"),
				'cancelled'  => __("سفارش های لغو شده", "lamakdeh"),
				'refunded'   => __("سفارش های لغو شده", "lamakdeh"),
				'failed'     => __("سفارش های لغو شده", "lamakdeh"),
			];

			// متغیرهای شمارش
			$current_orders = 0;
			$completed_orders = 0;
			$cancelled_orders = 0;

			$orders = wc_get_orders([
				'customer_id' => $current_user_id,
				'status'      => array_keys($statuses),
				'limit'       => -1,
				'return'      => 'ids',
			]);

			foreach ($orders as $order_id) {
				$order = wc_get_order($order_id);
				if (!$order) continue;
				$status = $order->get_status();

				if (in_array($status, ['processing', 'on-hold', 'pending'])) {
					$current_orders++;
				} elseif ($status === 'completed') {
					$completed_orders++;
				} elseif (in_array($status, ['cancelled', 'refunded', 'failed'])) {
					$cancelled_orders++;
				}
			}

			$orders_data = [
				[
					'title' => __("سفارش های جاری", "lamakdeh"),
					'count' => $current_orders,
					'url'   => wc_get_endpoint_url('orders', '', wc_get_page_permalink('myaccount')),
				],
				[
					'title' => __("سفارش های به اتمام رسیده", "lamakdeh"),
					'count' => $completed_orders,
					'url'   => wc_get_endpoint_url('orders', '', wc_get_page_permalink('myaccount')),
				],
				[
					'title' => __("سفارش های لغو شده", "lamakdeh"),
					'count' => $cancelled_orders,
					'url'   => wc_get_endpoint_url('orders', '', wc_get_page_permalink('myaccount')),
				],
			];

			foreach ($orders_data as $order) :
		?>
				<div class="order-item">
					<div class="order-item-circle"></div>
					<div class="order-item-content">
						<span><?php echo esc_html($order['title']); ?></span>
						<span><?php echo esc_html($order['count']); ?> <?php echo __("سفارش", "lamakdeh"); ?></span>
					</div>
					<a class="order-item-link" href="<?php echo esc_url($order['url']); ?>">
						<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
							<path fill-rule="evenodd" clip-rule="evenodd" d="M12.9067 3.69213C13.1688 3.91677 13.1992 4.31133 12.9745 4.57341L8.32316 10L12.9745 15.4266C13.1992 15.6887 13.1688 16.0832 12.9067 16.3079C12.6447 16.5325 12.2501 16.5022 12.0255 16.2401L7.02545 10.4067C6.82483 10.1727 6.82483 9.82731 7.02545 9.59326L12.0255 3.75992C12.2501 3.49784 12.6447 3.46749 12.9067 3.69213Z" fill="currentColor" />
						</svg>
					</a>
				</div>
		<?php
			endforeach;
		} else {
			echo '<p>' . __("برای مشاهده سفارش‌ها لطفاً وارد حساب کاربری خود شوید.", "lamakdeh") . '</p>';
		}
		?>
	</div>

	<a href="<?php echo esc_url(wc_get_endpoint_url('orders', '', wc_get_page_permalink('myaccount'))); ?>" class="orders-dashboard-bottom">
		<?php echo __("نمایش همه", "lamakdeh"); ?>
		<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M12.9067 3.6921C13.1688 3.91674 13.1992 4.3113 12.9745 4.57338L8.32316 9.99997L12.9745 15.4266C13.1992 15.6886 13.1688 16.0832 12.9067 16.3078C12.6447 16.5325 12.2501 16.5021 12.0255 16.24L7.02545 10.4067C6.82483 10.1727 6.82483 9.82728 7.02545 9.59323L12.0255 3.75989C12.2501 3.49781 12.6447 3.46746 12.9067 3.6921Z" fill="currentColor" />
		</svg>
	</a>
</section>
<?php
global $wpdb;
$user_id = get_current_user_id();
$table_name = $wpdb->prefix . 'lamkadeh_notifications';

$notifications = $wpdb->get_results($wpdb->prepare("
		SELECT * FROM $table_name
     	WHERE status = 'publish' AND (user_id = 0 OR user_id = %d)
     	ORDER BY id DESC
     	LIMIT 4
	", $user_id));
if ($notifications) :
?>
	<section class="news-dashboard">
		<div class="news-dashboard-items">
			<?php
			if (!function_exists('jdate')) {
				require_once(get_template_directory() . "/includes/date-convertor-shamsi/jdf.php");
			}
			foreach ($notifications as $n) {
				$timestamp = strtotime($n->created_at);
			?>
				<div class="news-item">
					<div class="news-item-header">
						<div class="news-item-header-right">
							<div class="news-item-header-right-icon">
								<svg width="56" height="56" viewBox="0 0 56 56" fill="none" xmlns="http://www.w3.org/2000/svg">
									<rect width="56" height="56" rx="28" fill="#1D2977" fill-opacity="0.2" />
									<path d="M27.9426 17.25C25.6342 17.25 23.8252 17.25 22.4137 17.4397C20.969 17.634 19.8289 18.0393 18.9341 18.9341C18.0393 19.8289 17.634 20.969 17.4397 22.4137C17.25 23.8252 17.25 25.6342 17.25 27.9426V28.0574C17.25 30.3658 17.25 32.1748 17.4397 33.5863C17.634 35.031 18.0393 36.1711 18.9341 37.0659C19.8289 37.9607 20.969 38.366 22.4137 38.5603C23.8252 38.75 25.6342 38.75 27.9426 38.75H28.0574C30.3658 38.75 32.1748 38.75 33.5863 38.5603C35.031 38.366 36.1711 37.9607 37.0659 37.0659C37.9607 36.1711 38.366 35.031 38.5603 33.5863C38.75 32.1748 38.75 30.3658 38.75 28.0574V26.5C38.75 26.0858 38.4142 25.75 38 25.75C37.5858 25.75 37.25 26.0858 37.25 26.5V28C37.25 30.3782 37.2484 32.0864 37.0736 33.3864C36.9018 34.6648 36.5749 35.4355 36.0052 36.0052C35.4355 36.5749 34.6648 36.9018 33.3864 37.0736C32.0864 37.2484 30.3782 37.25 28 37.25C25.6218 37.25 23.9136 37.2484 22.6136 37.0736C21.3352 36.9018 20.5645 36.5749 19.9948 36.0052C19.4251 35.4355 19.0982 34.6648 18.9264 33.3864C18.7516 32.0864 18.75 30.3782 18.75 28C18.75 25.6218 18.7516 23.9136 18.9264 22.6136C19.0982 21.3352 19.4251 20.5645 19.9948 19.9948C20.5645 19.4251 21.3352 19.0982 22.6136 18.9264C23.9136 18.7516 25.6218 18.75 28 18.75H29.5C29.9142 18.75 30.25 18.4142 30.25 18C30.25 17.5858 29.9142 17.25 29.5 17.25H27.9426Z" fill="#1D2977" />
									<path fill-rule="evenodd" clip-rule="evenodd" d="M35 17.25C32.9289 17.25 31.25 18.9289 31.25 21C31.25 23.0711 32.9289 24.75 35 24.75C37.0711 24.75 38.75 23.0711 38.75 21C38.75 18.9289 37.0711 17.25 35 17.25ZM32.75 21C32.75 19.7574 33.7574 18.75 35 18.75C36.2426 18.75 37.25 19.7574 37.25 21C37.25 22.2426 36.2426 23.25 35 23.25C33.7574 23.25 32.75 22.2426 32.75 21Z" fill="#1D2977" />
									<path d="M22.25 30C22.25 29.5858 22.5858 29.25 23 29.25H32C32.4142 29.25 32.75 29.5858 32.75 30C32.75 30.4142 32.4142 30.75 32 30.75H23C22.5858 30.75 22.25 30.4142 22.25 30Z" fill="#1D2977" />
									<path d="M23 32.75C22.5858 32.75 22.25 33.0858 22.25 33.5C22.25 33.9142 22.5858 34.25 23 34.25H29C29.4142 34.25 29.75 33.9142 29.75 33.5C29.75 33.0858 29.4142 32.75 29 32.75H23Z" fill="#1D2977" />
								</svg>
							</div>
							<div class="news-item-header-right-content">
								<span><?php echo esc_html($n->title) ?></span>
								<span><?php echo jdate('Y/m/d', $timestamp) ?></span>
							</div>
						</div>
						<div class="news-item-header-left">
							<svg width="27" height="29" viewBox="0 0 27 29" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M26.8084 7.55521C25.8558 4.56057 23.9325 1.96873 21.3424 0.189212C21.1238 0.0421467 20.856 -0.0127055 20.5972 0.0365755C20.3383 0.0858564 20.1094 0.235288 19.9602 0.452398C19.8109 0.669507 19.7533 0.936751 19.8 1.19605C19.8467 1.45536 19.9938 1.68577 20.2094 1.83721C22.432 3.36313 24.0826 5.58626 24.9004 8.15521C24.98 8.40823 25.1568 8.61928 25.3919 8.74192C25.6271 8.86457 25.9014 8.88878 26.1544 8.80921C26.4074 8.72965 26.6185 8.55283 26.7411 8.31766C26.8638 8.08249 26.888 7.80823 26.8084 7.55521ZM6.61439 1.84921C6.72898 1.77796 6.82796 1.68425 6.90538 1.57373C6.9828 1.46321 7.03705 1.33817 7.06486 1.20613C7.09268 1.0741 7.09348 0.937795 7.06723 0.805437C7.04098 0.67308 6.98821 0.547405 6.9121 0.43598C6.83599 0.324555 6.73812 0.229686 6.62439 0.157084C6.51065 0.0844825 6.38339 0.0356507 6.25028 0.0135295C6.11717 -0.00859177 5.98096 -0.0035448 5.84985 0.0283662C5.71874 0.0602773 5.59545 0.118392 5.48739 0.199212C2.89619 1.97091 0.977075 4.56355 0.0393923 7.55921C-0.0334 7.81083 -0.00456174 8.08096 0.119708 8.31154C0.243977 8.54212 0.453756 8.71474 0.703949 8.79229C0.954141 8.86983 1.22477 8.84612 1.45767 8.72624C1.69056 8.60636 1.86712 8.39989 1.94939 8.15121C2.75257 5.58628 4.39581 3.3664 6.61439 1.84921ZM23.4274 21.5672H22.5074V11.7972C22.5074 7.13921 18.9754 3.29421 14.4244 2.79021V1.71721C14.4244 1.452 14.319 1.19764 14.1315 1.01011C13.944 0.822569 13.6896 0.717212 13.4244 0.717212C13.1592 0.717212 12.9048 0.822569 12.7173 1.01011C12.5297 1.19764 12.4244 1.452 12.4244 1.71721V2.78721C7.88639 3.27921 4.34139 7.13121 4.34139 11.7972V21.5672H3.42139C3.15618 21.5672 2.90182 21.6726 2.71429 21.8601C2.52675 22.0476 2.42139 22.302 2.42139 22.5672C2.42139 22.8324 2.52675 23.0868 2.71429 23.2743C2.90182 23.4619 3.15618 23.5672 3.42139 23.5672H23.4274C23.6926 23.5672 23.947 23.4619 24.1345 23.2743C24.322 23.0868 24.4274 22.8324 24.4274 22.5672C24.4274 22.302 24.322 22.0476 24.1345 21.8601C23.947 21.6726 23.6926 21.5672 23.4274 21.5672ZM16.4894 26.0132H10.3274C10.0622 26.0132 9.80782 26.1186 9.62029 26.3061C9.43275 26.4936 9.32739 26.748 9.32739 27.0132C9.32739 27.2784 9.43275 27.5328 9.62029 27.7203C9.80782 27.9079 10.0622 28.0132 10.3274 28.0132H16.4894C16.7546 28.0132 17.009 27.9079 17.1965 27.7203C17.384 27.5328 17.4894 27.2784 17.4894 27.0132C17.4894 26.748 17.384 26.4936 17.1965 26.3061C17.009 26.1186 16.7546 26.0132 16.4894 26.0132Z" fill="#1D2977" />
							</svg>
							<svg width="27" height="29" viewBox="0 0 27 29" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M26.8084 7.55521C25.8558 4.56057 23.9325 1.96873 21.3424 0.189212C21.1238 0.0421467 20.856 -0.0127055 20.5972 0.0365755C20.3383 0.0858564 20.1094 0.235288 19.9602 0.452398C19.8109 0.669507 19.7533 0.936751 19.8 1.19605C19.8467 1.45536 19.9938 1.68577 20.2094 1.83721C22.432 3.36313 24.0826 5.58626 24.9004 8.15521C24.98 8.40823 25.1568 8.61928 25.3919 8.74192C25.6271 8.86457 25.9014 8.88878 26.1544 8.80921C26.4074 8.72965 26.6185 8.55283 26.7411 8.31766C26.8638 8.08249 26.888 7.80823 26.8084 7.55521ZM6.61439 1.84921C6.72898 1.77796 6.82796 1.68425 6.90538 1.57373C6.9828 1.46321 7.03705 1.33817 7.06486 1.20613C7.09268 1.0741 7.09348 0.937795 7.06723 0.805437C7.04098 0.67308 6.98821 0.547405 6.9121 0.43598C6.83599 0.324555 6.73812 0.229686 6.62439 0.157084C6.51065 0.0844825 6.38339 0.0356507 6.25028 0.0135295C6.11717 -0.00859177 5.98096 -0.0035448 5.84985 0.0283662C5.71874 0.0602773 5.59545 0.118392 5.48739 0.199212C2.89619 1.97091 0.977075 4.56355 0.0393923 7.55921C-0.0334 7.81083 -0.00456174 8.08096 0.119708 8.31154C0.243977 8.54212 0.453756 8.71474 0.703949 8.79229C0.954141 8.86983 1.22477 8.84612 1.45767 8.72624C1.69056 8.60636 1.86712 8.39989 1.94939 8.15121C2.75257 5.58628 4.39581 3.3664 6.61439 1.84921ZM23.4274 21.5672H22.5074V11.7972C22.5074 7.13921 18.9754 3.29421 14.4244 2.79021V1.71721C14.4244 1.452 14.319 1.19764 14.1315 1.01011C13.944 0.822569 13.6896 0.717212 13.4244 0.717212C13.1592 0.717212 12.9048 0.822569 12.7173 1.01011C12.5297 1.19764 12.4244 1.452 12.4244 1.71721V2.78721C7.88639 3.27921 4.34139 7.13121 4.34139 11.7972V21.5672H3.42139C3.15618 21.5672 2.90182 21.6726 2.71429 21.8601C2.52675 22.0476 2.42139 22.302 2.42139 22.5672C2.42139 22.8324 2.52675 23.0868 2.71429 23.2743C2.90182 23.4619 3.15618 23.5672 3.42139 23.5672H23.4274C23.6926 23.5672 23.947 23.4619 24.1345 23.2743C24.322 23.0868 24.4274 22.8324 24.4274 22.5672C24.4274 22.302 24.322 22.0476 24.1345 21.8601C23.947 21.6726 23.6926 21.5672 23.4274 21.5672ZM16.4894 26.0132H10.3274C10.0622 26.0132 9.80782 26.1186 9.62029 26.3061C9.43275 26.4936 9.32739 26.748 9.32739 27.0132C9.32739 27.2784 9.43275 27.5328 9.62029 27.7203C9.80782 27.9079 10.0622 28.0132 10.3274 28.0132H16.4894C16.7546 28.0132 17.009 27.9079 17.1965 27.7203C17.384 27.5328 17.4894 27.2784 17.4894 27.0132C17.4894 26.748 17.384 26.4936 17.1965 26.3061C17.009 26.1186 16.7546 26.0132 16.4894 26.0132Z" fill="#1D2977" />
							</svg>
						</div>
					</div>
					<div class="underline-lamkadeh">
						<div class="underline-lamkadeh-line"></div>
						<div class="underline-lamkadeh-circle"></div>
					</div>
					<div class="news-item-content">
						<p><?php echo wp_kses_post($n->message) ?></p>
					</div>
				</div>
			<?php } ?>
		</div>
		<a href="<?php echo esc_url(wc_get_endpoint_url('news', '', wc_get_page_permalink('myaccount'))); ?>" class="news-dashboard-link">
			<?php echo __("همه اخبار و اطلاعیه ها", "lamkadeh") ?>
			<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
				<path fill-rule="evenodd" clip-rule="evenodd" d="M12.9067 3.6921C13.1688 3.91674 13.1992 4.3113 12.9745 4.57338L8.32316 9.99997L12.9745 15.4266C13.1992 15.6886 13.1688 16.0832 12.9067 16.3078C12.6447 16.5325 12.2501 16.5021 12.0255 16.24L7.02545 10.4067C6.82483 10.1727 6.82483 9.82728 7.02545 9.59323L12.0255 3.75989C12.2501 3.49781 12.6447 3.46746 12.9067 3.6921Z" fill="#1D2977" />
			</svg>
		</a>
	</section>
<?php
else:
?>
	<section class="news-dashboard">
		<div class="news-dashboard-items">
			<section class="no-dashboard-lamkadeh">
				<svg width="72" height="72" viewBox="0 0 72 72" fill="none" xmlns="http://www.w3.org/2000/svg">
					<path d="M35.8279 3.75C28.9027 3.74996 23.4756 3.74993 19.2411 4.31924C14.9069 4.90196 11.4868 6.11798 8.80241 8.80241C6.11798 11.4868 4.90196 14.9069 4.31924 19.2411C3.74993 23.4756 3.74996 28.9027 3.75 35.8279V36.1721C3.74996 43.0973 3.74993 48.5244 4.31924 52.7589C4.90196 57.0931 6.11798 60.5132 8.80241 63.1976C11.4868 65.882 14.9069 67.098 19.2411 67.6808C23.4756 68.2501 28.9027 68.25 35.8279 68.25H36.1721C43.0973 68.25 48.5244 68.2501 52.7589 67.6808C57.0931 67.098 60.5132 65.882 63.1976 63.1976C65.882 60.5132 67.098 57.0931 67.6808 52.7589C68.2501 48.5244 68.25 43.0973 68.25 36.1721V31.5C68.25 30.2574 67.2426 29.25 66 29.25C64.7574 29.25 63.75 30.2574 63.75 31.5V36C63.75 43.1347 63.7452 48.2593 63.2209 52.1593C62.7053 55.9945 61.7246 58.3066 60.0156 60.0156C58.3066 61.7246 55.9945 62.7053 52.1593 63.2209C48.2593 63.7452 43.1347 63.75 36 63.75C28.8653 63.75 23.7407 63.7452 19.8407 63.2209C16.0055 62.7053 13.6934 61.7246 11.9844 60.0156C10.2754 58.3066 9.29474 55.9945 8.77911 52.1593C8.25478 48.2593 8.25 43.1347 8.25 36C8.25 28.8653 8.25478 23.7407 8.77911 19.8407C9.29474 16.0055 10.2754 13.6934 11.9844 11.9844C13.6934 10.2754 16.0055 9.29474 19.8407 8.77911C23.7407 8.25478 28.8653 8.25 36 8.25H40.5C41.7426 8.25 42.75 7.24264 42.75 6C42.75 4.75736 41.7426 3.75 40.5 3.75H35.8279Z" fill="#1D2977" />
					<path fill-rule="evenodd" clip-rule="evenodd" d="M57 3.75C50.7868 3.75 45.75 8.7868 45.75 15C45.75 21.2132 50.7868 26.25 57 26.25C63.2132 26.25 68.25 21.2132 68.25 15C68.25 8.7868 63.2132 3.75 57 3.75ZM50.25 15C50.25 11.2721 53.2721 8.25 57 8.25C60.7279 8.25 63.75 11.2721 63.75 15C63.75 18.7279 60.7279 21.75 57 21.75C53.2721 21.75 50.25 18.7279 50.25 15Z" fill="#1D2977" />
					<path d="M18.75 42C18.75 40.7574 19.7574 39.75 21 39.75H48C49.2426 39.75 50.25 40.7574 50.25 42C50.25 43.2426 49.2426 44.25 48 44.25H21C19.7574 44.25 18.75 43.2426 18.75 42Z" fill="#1D2977" />
					<path d="M21 50.25C19.7574 50.25 18.75 51.2574 18.75 52.5C18.75 53.7426 19.7574 54.75 21 54.75H39C40.2426 54.75 41.25 53.7426 41.25 52.5C41.25 51.2574 40.2426 50.25 39 50.25H21Z" fill="#1D2977" />
				</svg>
				<span><?php echo __("شما هنوز اخبار و اطلاعیه ای دریافت نکرده اید.", "lamkadeh") ?></span>
			</section>
		</div>
		<a href="<?php echo esc_url(wc_get_endpoint_url('news', '', wc_get_page_permalink('myaccount'))); ?>" class="news-dashboard-link">
			<?php echo __("همه اخبار و اطلاعیه ها", "lamkadeh") ?>
			<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
				<path fill-rule="evenodd" clip-rule="evenodd" d="M12.9067 3.6921C13.1688 3.91674 13.1992 4.3113 12.9745 4.57338L8.32316 9.99997L12.9745 15.4266C13.1992 15.6886 13.1688 16.0832 12.9067 16.3078C12.6447 16.5325 12.2501 16.5021 12.0255 16.24L7.02545 10.4067C6.82483 10.1727 6.82483 9.82728 7.02545 9.59323L12.0255 3.75989C12.2501 3.49781 12.6447 3.46746 12.9067 3.6921Z" fill="#1D2977" />
			</svg>
		</a>
	</section>
<?php
endif;
?>
<?php
/**
 * My Account dashboard.
 *
 * @since 2.6.0
 */
do_action('woocommerce_account_dashboard');

/**
 * Deprecated woocommerce_before_my_account action.
 *
 * @deprecated 2.6.0
 */
do_action('woocommerce_before_my_account');

/**
 * Deprecated woocommerce_after_my_account action.
 *
 * @deprecated 2.6.0
 */
do_action('woocommerce_after_my_account');

/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
