<?php

/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.4.0
 */

defined('ABSPATH') || exit;

global $product;

// Check if the product is a valid WooCommerce product and ensure its visibility before proceeding.
if (! is_a($product, WC_Product::class) || ! $product->is_visible()) {
	return;
}
?>

<div class="product-archive-content-item">
	<div class="product-archive-content-item-header">
		<?php
		if (has_post_thumbnail($product->get_id())) {
			echo get_the_post_thumbnail($product->get_id(), 'woocommerce_thumbnail', array(
				'class' => 'lamkadeh-product-image',
				'alt'   => get_the_title($product->get_id()),
			));
		} else {
			echo '<img src="' . esc_url(wc_placeholder_img_src()) . '" alt="' . esc_attr(get_the_title($product->get_id())) . '" class="lamkadeh-product-image" />';
		}
		?>
		<div class="product-archive-content-item-header-button">
			<div class="product-archive-content-item-header-button-item product-share-btn" data-product-title="<?php echo $product->get_title() ?>" data-product-url="<?php echo esc_url($product->get_permalink()) ?>">
				<svg width="18" height="18" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
					<path fill-rule="evenodd" clip-rule="evenodd" d="M16.5 2.25C14.7051 2.25 13.25 3.70507 13.25 5.5C13.25 5.69591 13.2673 5.88776 13.3006 6.07412L8.56991 9.38558C8.54587 9.4024 8.52312 9.42038 8.50168 9.43939C7.94993 9.00747 7.25503 8.75 6.5 8.75C4.70507 8.75 3.25 10.2051 3.25 12C3.25 13.7949 4.70507 15.25 6.5 15.25C7.25503 15.25 7.94993 14.9925 8.50168 14.5606C8.52312 14.5796 8.54587 14.5976 8.56991 14.6144L13.3006 17.9259C13.2673 18.1122 13.25 18.3041 13.25 18.5C13.25 20.2949 14.7051 21.75 16.5 21.75C18.2949 21.75 19.75 20.2949 19.75 18.5C19.75 16.7051 18.2949 15.25 16.5 15.25C15.4472 15.25 14.5113 15.7506 13.9174 16.5267L9.43806 13.3911C9.63809 12.9694 9.75 12.4978 9.75 12C9.75 11.5022 9.63809 11.0306 9.43806 10.6089L13.9174 7.4733C14.5113 8.24942 15.4472 8.75 16.5 8.75C18.2949 8.75 19.75 7.29493 19.75 5.5C19.75 3.70507 18.2949 2.25 16.5 2.25ZM14.75 5.5C14.75 4.5335 15.5335 3.75 16.5 3.75C17.4665 3.75 18.25 4.5335 18.25 5.5C18.25 6.4665 17.4665 7.25 16.5 7.25C15.5335 7.25 14.75 6.4665 14.75 5.5ZM6.5 10.25C5.5335 10.25 4.75 11.0335 4.75 12C4.75 12.9665 5.5335 13.75 6.5 13.75C7.4665 13.75 8.25 12.9665 8.25 12C8.25 11.0335 7.4665 10.25 6.5 10.25ZM16.5 16.75C15.5335 16.75 14.75 17.5335 14.75 18.5C14.75 19.4665 15.5335 20.25 16.5 20.25C17.4665 20.25 18.25 19.4665 18.25 18.5C18.25 17.5335 17.4665 16.75 16.5 16.75Z" fill="#1D2977" />
				</svg>
			</div>
			<?php if (is_user_logged_in()) :
				$user_id = get_current_user_id();
				$wishlist = get_user_meta($user_id, 'lamkadeh_wishlist', true);
				$is_favorite = is_array($wishlist) && in_array($product->get_id(), $wishlist);
			?>
				<div class="product-archive-content-item-header-button-item wishlist-btn <?php echo $is_favorite ? 'active' : ''; ?>" data-product-id="<?php echo esc_attr($product->get_id()); ?>">
					<svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path fill-rule="evenodd" clip-rule="evenodd" d="M4.21827 3.31808C2.97403 3.88683 2.0625 5.23961 2.0625 6.85276C2.0625 8.50081 2.73691 9.77111 3.70371 10.8598C4.50054 11.757 5.46513 12.5007 6.40584 13.2259C6.62928 13.3981 6.85136 13.5694 7.06953 13.7413C7.46406 14.0524 7.81599 14.3253 8.15521 14.5236C8.49461 14.7219 8.7678 14.8124 9 14.8124C9.2322 14.8124 9.50539 14.7219 9.84479 14.5236C10.184 14.3253 10.5359 14.0524 10.9305 13.7413C11.1486 13.5694 11.3707 13.3981 11.5942 13.2259C12.5349 12.5007 13.4995 11.757 14.2963 10.8598C15.2631 9.77111 15.9375 8.50081 15.9375 6.85276C15.9375 5.23961 15.026 3.88683 13.7817 3.31808C12.5729 2.76554 10.9488 2.91187 9.40527 4.51548C9.29923 4.62566 9.15291 4.68791 9 4.68791C8.84709 4.68791 8.70077 4.62566 8.59473 4.51548C7.05125 2.91187 5.42705 2.76554 4.21827 3.31808ZM9 3.34404C7.26596 1.79261 5.32422 1.57559 3.75057 2.2949C2.08853 3.05463 0.9375 4.81871 0.9375 6.85276C0.9375 8.85191 1.77037 10.377 2.86254 11.6068C3.73715 12.5916 4.80767 13.4159 5.75312 14.1439C5.96744 14.3089 6.17533 14.469 6.37306 14.6248C6.75724 14.9277 7.16966 15.2506 7.58762 15.4949C8.00539 15.739 8.4822 15.9374 9 15.9374C9.5178 15.9374 9.99461 15.739 10.4124 15.4949C10.8303 15.2506 11.2428 14.9277 11.6269 14.6248C11.8247 14.469 12.0326 14.3089 12.2469 14.1439C13.1923 13.4159 14.2628 12.5916 15.1375 11.6068C16.2296 10.377 17.0625 8.85191 17.0625 6.85276C17.0625 4.81871 15.9115 3.05463 14.2494 2.2949C12.6758 1.57559 10.734 1.79261 9 3.34404Z" fill="#1D2977" />
					</svg>
				</div>
			<?php else : ?>
				<div class="product-archive-content-item-header-button-item" onclick="loginBeforeWhishlist()">
					<svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path fill-rule="evenodd" clip-rule="evenodd" d="M4.21827 3.31808C2.97403 3.88683 2.0625 5.23961 2.0625 6.85276C2.0625 8.50081 2.73691 9.77111 3.70371 10.8598C4.50054 11.757 5.46513 12.5007 6.40584 13.2259C6.62928 13.3981 6.85136 13.5694 7.06953 13.7413C7.46406 14.0524 7.81599 14.3253 8.15521 14.5236C8.49461 14.7219 8.7678 14.8124 9 14.8124C9.2322 14.8124 9.50539 14.7219 9.84479 14.5236C10.184 14.3253 10.5359 14.0524 10.9305 13.7413C11.1486 13.5694 11.3707 13.3981 11.5942 13.2259C12.5349 12.5007 13.4995 11.757 14.2963 10.8598C15.2631 9.77111 15.9375 8.50081 15.9375 6.85276C15.9375 5.23961 15.026 3.88683 13.7817 3.31808C12.5729 2.76554 10.9488 2.91187 9.40527 4.51548C9.29923 4.62566 9.15291 4.68791 9 4.68791C8.84709 4.68791 8.70077 4.62566 8.59473 4.51548C7.05125 2.91187 5.42705 2.76554 4.21827 3.31808ZM9 3.34404C7.26596 1.79261 5.32422 1.57559 3.75057 2.2949C2.08853 3.05463 0.9375 4.81871 0.9375 6.85276C0.9375 8.85191 1.77037 10.377 2.86254 11.6068C3.73715 12.5916 4.80767 13.4159 5.75312 14.1439C5.96744 14.3089 6.17533 14.469 6.37306 14.6248C6.75724 14.9277 7.16966 15.2506 7.58762 15.4949C8.00539 15.739 8.4822 15.9374 9 15.9374C9.5178 15.9374 9.99461 15.739 10.4124 15.4949C10.8303 15.2506 11.2428 14.9277 11.6269 14.6248C11.8247 14.469 12.0326 14.3089 12.2469 14.1439C13.1923 13.4159 14.2628 12.5916 15.1375 11.6068C16.2296 10.377 17.0625 8.85191 17.0625 6.85276C17.0625 4.81871 15.9115 3.05463 14.2494 2.2949C12.6758 1.57559 10.734 1.79261 9 3.34404Z" fill="#1D2977" />
					</svg>
				</div>
			<?php endif; ?>
		</div>
	</div>
	<div class="single-product-lamkadeh-item-bottom">
		<div class="single-product-lamkadeh-item-bottom-header">

			<div class="single-product-lamkadeh-item-bottom-header-name">
				<div class="single-product-lamkadeh-item-bottom-header-category">
					<?php
					global $product;

					$categories = get_the_terms($product->get_id(), 'product_cat');

					if ($categories && !is_wp_error($categories)) {
						$main_category = null;
						foreach ($categories as $category) {
							if ($category->parent == 0) {
								$main_category = $category;
								break;
							}
						}

						if (!$main_category) {
							$main_category = reset($categories);
						}

						if ($main_category) {
							$thumbnail_id = get_term_meta($main_category->term_id, 'thumbnail_id', true);
							$image_url = $thumbnail_id
								? wp_get_attachment_image_url($thumbnail_id, 'thumbnail')
								: wc_placeholder_img_src();
					?>
							<a href="<?php echo esc_url(get_term_link($main_category)) ?>" target="_blank" rel="follow" class="single-product-lamkadeh-item-bottom-header-category-name">

								<img src="<?php echo esc_url($image_url) ?>" alt="<?php echo esc_attr($main_category->name) ?>">
								<span><?php echo esc_html($main_category->name) ?></span>
							</a>
					<?php
						}
					}
					?>
					<?php
					if ($product && is_a($product, 'WC_Product')) {

						$is_in_stock = $product->is_in_stock();

						$stock_class = $is_in_stock ? 'in-stock' : 'out-of-stock';
						$stock_text  = $is_in_stock ? __('موجود در انبار', 'lamkadeh') : __('ناموجود در انبار', 'lamkadeh');
						$stock_color = $is_in_stock ? '#02734C' : '#CC0000';
					?>

						<div class="single-product-lamkadeh-item-bottom-header-category-stock <?php echo esc_attr($stock_class); ?>">
							<svg width="16" height="16" viewBox="0 0 16 16" fill="none"
								xmlns="http://www.w3.org/2000/svg">
								<g clip-path="url(#clip0_1_11360)">
									<?php if ($is_in_stock) : ?>
										<path d="M10.6866 6.68693C10.8818 6.49167 10.8818 6.17508 10.6866 5.97982C10.4913 5.78456 10.1747 5.78456 9.97945 5.97982L6.99968 8.9596L6.01989 7.97982C5.82463 7.78456 5.50805 7.78456 5.31279 7.97982C5.11753 8.17508 5.11753 8.49167 5.31279 8.68693L6.64612 10.0203C6.84138 10.2155 7.15797 10.2155 7.35323 10.0203L10.6866 6.68693Z" fill="<?php echo esc_attr($stock_color); ?>" />
										<path fill-rule="evenodd" clip-rule="evenodd" d="M7.99967 0.833373C4.04163 0.833374 0.833008 4.042 0.833008 8.00004C0.833009 11.9581 4.04164 15.1667 7.99968 15.1667C11.9577 15.1667 15.1663 11.9581 15.1663 8.00004C15.1663 4.042 11.9577 0.833373 7.99967 0.833373ZM1.83301 8.00004C1.83301 4.59429 4.59392 1.83337 7.99967 1.83337C11.4054 1.83337 14.1663 4.59428 14.1663 8.00004C14.1663 11.4058 11.4054 14.1667 7.99968 14.1667C4.59392 14.1667 1.83301 11.4058 1.83301 8.00004Z" fill="<?php echo esc_attr($stock_color); ?>" />
									<?php else : ?>
										<path d="M5.5 5.5L10.5 10.5M10.5 5.5L5.5 10.5" stroke="<?php echo esc_attr($stock_color); ?>" stroke-width="1.2" stroke-linecap="round" />
										<circle cx="8" cy="8" r="7.2" stroke="<?php echo esc_attr($stock_color); ?>" stroke-width="1.2" />
									<?php endif; ?>
								</g>
								<defs>
									<clipPath id="clip0_1_11360">
										<rect width="16" height="16" fill="white" />
									</clipPath>
								</defs>
							</svg>
							<span><?php echo esc_html($stock_text); ?></span>
						</div>

					<?php } ?>
				</div>
				<a href="<?php echo esc_url($product->get_permalink()) ?>" class="single-product-lamkadeh-item-bottom-header-name-title"><?php echo $product->get_title() ?></a>
			</div>

			<div class="underline-lamkadeh">
				<div class="underline-lamkadeh-line"></div>
				<div class="underline-lamkadeh-circle"></div>
			</div>
			<?php
			$regular_price = floatval($product->get_regular_price());
			$sale_price = floatval($product->get_sale_price());
			$discount_percent = 0;
			if ($product->is_type('variable')) {
				$prices = $product->get_variation_prices(true);
				$max_regular = !empty($prices['regular_price']) ? max($prices['regular_price']) : 0;
				$min_sale = !empty($prices['sale_price']) ? min($prices['sale_price']) : 0;

				if ($min_sale && $min_sale < $max_regular) {
					$discount_percent = round((($max_regular - $min_sale) / $max_regular) * 100);
				}
				$display_regular = $max_regular;
				$display_sale = $min_sale ? $min_sale : $max_regular;
			} else {
				$display_regular = $regular_price;
				$display_sale = $sale_price ? $sale_price : $regular_price;

				if ($sale_price && $sale_price < $regular_price) {
					$discount_percent = round((($regular_price - $sale_price) / $regular_price) * 100);
				}
			}
			?>
			<div class="single-product-lamkadeh-item-bottom-header-price" data-product-id="<?php echo esc_attr($product->get_id()); ?>">

				<?php if ($discount_percent > 0): ?>
					<div class="single-product-lamkadeh-item-bottom-header-price-regular">
						<div class="single-product-lamkadeh-item-bottom-header-price-regular-number">
							<?php echo format_price($display_regular); ?>
						</div>
						<div class="single-product-lamkadeh-item-bottom-header-price-regular-discount">
							%<?php echo esc_html($discount_percent); ?>
						</div>
					</div>
				<?php endif; ?>

				<div class="single-product-lamkadeh-item-bottom-header-price-sales-off">
					<div class="single-product-lamkadeh-item-bottom-header-price-sales-off-shape"></div>
					<span class="single-product-lamkadeh-item-bottom-header-price-sales-off-number">
						<?php echo format_price($display_sale); ?>
					</span>
					<span class="single-product-lamkadeh-item-bottom-header-price-sales-off-symbol">تومان</span>
				</div>
			</div>

			<?php if ($product->is_type('variable')): ?>
				<script>
					document.addEventListener('DOMContentLoaded', function() {
						const wrapper = document.querySelector('.single-product-lamkadeh-item-bottom-header-price');
						const form = document.querySelector('form.variations_form');

						if (form && wrapper) {
							jQuery(form).on('found_variation', function(event, variation) {
								const regular = variation.display_regular_price;
								const sale = variation.display_price;
								const discount = regular > sale ? Math.round(((regular - sale) / regular) * 100) : 0;

								const regularBox = wrapper.querySelector('.single-product-lamkadeh-item-bottom-header-price-regular');
								const regularNumber = wrapper.querySelector('.single-product-lamkadeh-item-bottom-header-price-regular-number');
								const discountEl = wrapper.querySelector('.single-product-lamkadeh-item-bottom-header-price-regular-discount');
								const saleNumber = wrapper.querySelector('.single-product-lamkadeh-item-bottom-header-price-sales-off-number');

								if (discount > 0) {
									regularBox.style.display = 'flex';
									regularNumber.textContent = regular.toLocaleString();
									discountEl.textContent = '%' + discount;
								} else {
									regularBox.style.display = 'none';
								}

								saleNumber.textContent = sale.toLocaleString();
							});

							jQuery(form).on('reset_data', function() {
								const regularBox = wrapper.querySelector('.single-product-lamkadeh-item-bottom-header-price-regular');
								const regularNumber = wrapper.querySelector('.single-product-lamkadeh-item-bottom-header-price-regular-number');
								const discountEl = wrapper.querySelector('.single-product-lamkadeh-item-bottom-header-price-regular-discount');
								const saleNumber = wrapper.querySelector('.single-product-lamkadeh-item-bottom-header-price-sales-off-number');

								<?php if ($discount_percent > 0): ?>
									regularBox.style.display = 'flex';
									regularNumber.textContent = '<?php echo format_price($display_regular); ?>';
									discountEl.textContent = '%<?php echo $discount_percent; ?>';
								<?php else: ?>
									regularBox.style.display = 'none';
								<?php endif; ?>

								saleNumber.textContent = '<?php echo format_price($display_sale); ?>';
							});
						}
					});
				</script>
			<?php endif; ?>

			<div class="underline-lamkadeh">
				<div class="underline-lamkadeh-line"></div>
				<div class="underline-lamkadeh-circle"></div>
			</div>
		</div>
		<?php
		$product_id = (int) $product->get_id();

		$buyers_map = lamkadeh_get_buyers_for_product($product_id);
		$buyer_count = count($buyers_map);

		$buyers_list = array_values($buyers_map);
		shuffle($buyers_list);
		$random_buyers = array_slice($buyers_list, 0, 3);

		$fallback_avatar = esc_url(get_template_directory_uri() . '/assets/images/theme/avatar.png');

		if ($buyer_count >= 1) {
		?>
			<div class="single-product-lamkadeh-item-bottom-content">
				<div class="single-product-lamkadeh-item-bottom-content-img">
					<?php
					if (! empty($random_buyers)) {
						foreach ($random_buyers as $b) {
							$avatar_url = $fallback_avatar;

							if (isset($b['type']) && $b['type'] === 'user' && ! empty($b['id'])) {
								$custom_avatar = get_user_meta((int)$b['id'], 'lamkadeh_user_avatar', true);
								if ($custom_avatar) {
									$avatar_url = esc_url($custom_avatar);
								} else {
									$avatar_url = get_avatar_url((int) $b['id'], array('size' => 80));
								}
							} elseif (isset($b['type']) && $b['type'] === 'email' && ! empty($b['email'])) {
								$avatar_url = get_avatar_url($b['email'], array('size' => 80));
							}
					?>
							<img src="<?php echo esc_url($avatar_url); ?>" alt="">
						<?php
						}
					} else {
						?>
						<img src="<?php echo $fallback_avatar; ?>" alt="">
						<img src="<?php echo $fallback_avatar; ?>" alt="">
					<?php
					}
					?>
				</div>
				<span>
					<strong><?php echo esc_html(number_format_i18n($buyer_count)); ?>+ </strong>
					<?php echo esc_html__('نفر از این محصول خرید کرده‌اند', 'lamkadeh'); ?>
				</span>
			</div>
		<?php
		}
		?>
	</div>
</div>
