<?php

/**
 * Checkout Payment Section
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/payment.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.8.0
 */

defined('ABSPATH') || exit;

if (! wp_doing_ajax()) {
	do_action('woocommerce_review_order_before_payment');
}
?>
<div id="payment" class="woocommerce-checkout-payment">
	<?php if (WC()->cart && WC()->cart->needs_payment()) : ?>
		<ul class="wc_payment_methods payment_methods methods">
			<?php
			if (! empty($available_gateways)) {
				foreach ($available_gateways as $gateway) {
					wc_get_template('checkout/payment-method.php', array('gateway' => $gateway));
				}
			} else {
				echo '<li>';
				wc_print_notice(apply_filters('woocommerce_no_available_payment_methods_message', WC()->customer->get_billing_country() ? esc_html__('Sorry, it seems that there are no available payment methods. Please contact us if you require assistance or wish to make alternate arrangements.', 'woocommerce') : esc_html__('Please fill in your details above to see available payment methods.', 'woocommerce')), 'notice'); // phpcs:ignore WooCommerce.Commenting.CommentHooks.MissingHookComment
				echo '</li>';
			}
			?>
		</ul>
	<?php endif; ?>
	<div class="form-row place-order">
		<noscript>
			<?php
			/* translators: $1 and $2 opening and closing emphasis tags respectively */
			printf(esc_html__('Since your browser does not support JavaScript, or it is disabled, please ensure you click the %1$sUpdate Totals%2$s button before placing your order. You may be charged more than the amount stated above if you fail to do so.', 'woocommerce'), '<em>', '</em>');
			?>
			<br /><button type="submit" class="button alt<?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?>" name="woocommerce_checkout_update_totals" value="<?php esc_attr_e('Update totals', 'woocommerce'); ?>"><?php esc_html_e('Update totals', 'woocommerce'); ?></button>
		</noscript>

		<?php do_action('woocommerce_review_order_before_submit'); ?>

		<button
			type="submit"
			class="woocommerce-order-button-html"
			name="woocommerce_checkout_place_order"
			id="place_order"
			value="<?php echo esc_attr($order_button_text) ?>"
			data-value="<?php echo esc_attr($order_button_text) ?>">
			<span><?php echo __("ادامه و پرداخت", "lamkadeh") ?></span>
			<svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
				<path d="M23.4214 13.4056C23.2646 13.5623 23.0502 13.6613 22.8027 13.6613L13.6621 13.6613L13.6621 22.8019C13.6621 23.2803 13.2662 23.6763 12.7877 23.6763C12.3092 23.6763 11.9132 23.2803 11.9132 22.8019L11.9132 12.7869C11.9132 12.3084 12.3092 11.9124 12.7877 11.9124L22.8027 11.9124C23.2811 11.9124 23.6771 12.3084 23.6771 12.7869C23.6854 13.0261 23.5781 13.2489 23.4214 13.4056Z" fill="white" />
				<path d="M27.4297 27.4298C27.0914 27.7681 26.5304 27.7681 26.1922 27.4298L12.3082 13.5458C11.9699 13.2075 11.9699 12.6466 12.3082 12.3083C12.6464 11.9701 13.2074 11.9701 13.5456 12.3083L27.4297 26.1924C27.7679 26.5306 27.7679 27.0916 27.4297 27.4298Z" fill="white" />
			</svg>
		</button>

		<?php do_action('woocommerce_review_order_after_submit'); ?>

		<?php wp_nonce_field('woocommerce-process_checkout', 'woocommerce-process-checkout-nonce'); ?>
	</div>
</div>
<?php
if (! wp_doing_ajax()) {
	do_action('woocommerce_review_order_after_payment');
}
