<?php

namespace Elementor;

if (!defined('ABSPATH'))
    exit;

class Mega_Menu extends Widget_Base
{
    public function get_name()
    {
        return 'Mega_Menu';
    }

    public function get_title()
    {
        return __('مگامنو لمکده', 'lamkadeh');
    }

    public function get_icon()
    {
        return 'eicon-editor-list-ul';
    }

    public function get_categories()
    {
        return ['lamkadeh'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'section_tabs',
            [
                'label' => __('تب‌ها', 'lamkadeh'),
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'tab_title',
            [
                'label' => __('عنوان تب', 'lamkadeh'),
                'type' => Controls_Manager::TEXT,
                'default' => __('عنوان تب', 'lamkadeh'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'tab_link',
            [
                'label' => __('لینک تب', 'lamkadeh'),
                'type' => Controls_Manager::URL,
            ]
        );

        // آیکون (SVG یا FontAwesome)
        $repeater->add_control(
            'tab_icon',
            [
                'label' => __('آیکون تب', 'lamkadeh'),
                'type' => Controls_Manager::ICONS,
            ]
        );

        // بنر
        $repeater->add_control(
            'banner_image',
            [
                'label' => __('تصویر بنر', 'lamkadeh'),
                'type' => Controls_Manager::MEDIA,
            ]
        );
        $repeater->add_control(
            'banner_title',
            [
                'label' => __('عنوان بنر', 'lamkadeh'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => __('عنوان بنر', 'lamkadeh'),
            ]
        );
        $repeater->add_control(
            'banner_button_text',
            [
                'label' => __('متن دکمه بنر', 'lamkadeh'),
                'type' => Controls_Manager::TEXT,
                'default' => __('مشاهده همه', 'lamkadeh'),
            ]
        );
        $repeater->add_control(
            'banner_button_link',
            [
                'label' => __('لینک دکمه بنر', 'lamkadeh'),
                'type' => Controls_Manager::URL,
            ]
        );

        for ($col = 1; $col <= 2; $col++) {
            for ($i = 1; $i <= 7; $i++) {

                $repeater->add_control(
                    'list' . $col . '_item' . $i,
                    [
                        'label' => __("ستون $col آیتم $i", 'lamkadeh'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => __('آیتم', 'lamkadeh'),
                    ]
                );

                $repeater->add_control(
                    'list' . $col . '_item' . $i . '_link',
                    [
                        'label' => __('لینک آیتم', 'lamkadeh'),
                        'type' => \Elementor\Controls_Manager::URL,
                        'placeholder' => __('https://example.com', 'lamkadeh'),
                        'options' => ['url', 'is_external', 'nofollow'],
                        'default' => [
                            'url' => '#',
                            'is_external' => false,
                            'nofollow' => false,
                        ],
                    ]
                );

                $repeater->add_control(
                    'list' . $col . '_item' . $i . '_new',
                    [
                        'label' => __('جدید؟', 'lamkadeh'),
                        'type' => \Elementor\Controls_Manager::SWITCHER,
                        'label_on' => __('بله', 'lamkadeh'),
                        'label_off' => __('خیر', 'lamkadeh'),
                        'return_value' => 'yes',
                    ]
                );
            }
        }

        $this->add_control(
            'tabs',
            [
                'label' => __('لیست تب‌ها', 'lamkadeh'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    ['tab_title' => __('تب 1', 'lamkadeh')],
                    ['tab_title' => __('تب 2', 'lamkadeh')],
                ],
                'title_field' => '{{{ tab_title }}}',
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
?>
        <div class="mega-menu">
            <div class="mega-menu-content">
                <?php foreach ($settings['tabs'] as $index => $tab):
                    $tab_id = 'tab' . ($index + 1); ?>
                    <div id="<?php echo esc_attr($tab_id); ?>" class="mega-menu-content-item">
                        <div class="mega-menu-content-item-container">
                            <div class="mega-menu-content-item-banner"
                                style="background: url(<?php echo esc_url($tab['banner_image']['url']); ?>);">
                                <div class="mega-menu-content-item-banner-content">
                                    <span><?php echo wp_kses_post($tab['banner_title']); ?></span>
                                    <a href="<?php echo esc_url($tab['banner_button_link']['url']); ?>">
                                        <?php echo esc_html($tab['banner_button_text']); ?>
                                        <svg width="17" height="16" viewBox="0 0 17 16" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M10.7253 13.28L6.37859 8.93333C5.86526 8.42 5.86526 7.58 6.37859 7.06667L10.7253 2.72"
                                                stroke="#1D2977" stroke-width="1.04835" stroke-miterlimit="10"
                                                stroke-linecap="round" stroke-linejoin="round"></path>
                                        </svg>
                                    </a>
                                </div>
                            </div>
                            <div class="mega-menu-content-item-left">
                                <div class="mega-menu-content-item-left-title">
                                    <h4><a href="<?php echo esc_html($tab['tab_link']); ?>"><?php echo esc_html($tab['tab_title']); ?></a></h4>
                                </div>
                                <div class="underline-mega-menu-content-item-left"></div>
                                <div class="list-mega-menu-content-item-left">
                                    <div class="list-content-mega-menu-content-item-left">
                                        <?php for ($col = 1; $col <= 2; $col++): ?>
                                            <div class="list-content-<?php echo ($col == 1) ? 'right' : 'left'; ?>-mega-menu-content-item-left">
                                                <ul>
                                                    <?php for ($i = 1; $i <= 7; $i++):

                                                        $item = $tab['list' . $col . '_item' . $i] ?? '';
                                                        $new  = !empty($tab['list' . $col . '_item' . $i . '_new']) && $tab['list' . $col . '_item' . $i . '_new'] === 'yes';

                                                        $link_data = $tab['list' . $col . '_item' . $i . '_link'] ?? [];

                                                        $url = !empty($link_data['url']) ? esc_url($link_data['url']) : '';
                                                        $target = !empty($link_data['is_external']) ? ' target="_blank"' : '';
                                                        $nofollow = !empty($link_data['nofollow']) ? ' rel="nofollow"' : '';

                                                        if ($item):
                                                    ?>
                                                            <li>
                                                                <?php if ($url): ?>
                                                                    <a href="<?php echo $url; ?>" <?php echo $target . $nofollow; ?>>
                                                                        <?php echo esc_html($item); ?>
                                                                    </a>
                                                                <?php else: ?>
                                                                    <span><?php echo esc_html($item); ?></span>
                                                                <?php endif; ?>

                                                                <?php if ($new): ?>
                                                                    <span class="badge"><?php _e('جدید', 'lamkadeh'); ?></span>
                                                                <?php endif; ?>
                                                            </li>
                                                    <?php endif;
                                                    endfor; ?>
                                                </ul>
                                            </div>
                                        <?php endfor; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
            <div class="mega-menu-tab">
                <?php foreach ($settings['tabs'] as $index => $tab):
                    $tab_id = 'tab' . ($index + 1); ?>
                    <div data-tab="<?php echo esc_attr($tab_id); ?>" class="mega-menu-tab-item">
                        <?php \Elementor\Icons_Manager::render_icon($tab['tab_icon'], ['aria-hidden' => 'true']); ?>
                        <a href="<?php echo esc_url($tab['tab_link']["url"]); ?>"><?php echo esc_html($tab['tab_title']); ?></a>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        <div class="mega-menu-responsive">
            <!-- Tabs -->
            <div class="mega-menu-tab-responsive">
                <?php foreach ($settings['tabs'] as $index => $tab):
                    $tab_id = 'tab-responsive' . ($index + 1); ?>

                    <div class="mega-menu-tab-item-responsive" data-tab-responsive="<?php echo esc_attr($tab_id); ?>">
                        <?php // \Elementor\Icons_Manager::render_icon($tab['tab_icon'], ['aria-hidden' => 'true']); 
                        ?>
                        <span><?php echo esc_html($tab['tab_title']); ?></span>
                    </div>

                <?php endforeach; ?>
            </div>

            <!-- Contents -->
            <?php foreach ($settings['tabs'] as $index => $tab):
                $tab_id = 'tab-responsive' . ($index + 1); ?>
                <div id="<?php echo esc_attr($tab_id); ?>" class="mega-menu-content-responsive">
                    <h5><?php echo esc_html($tab['tab_title']); ?></h5>
                    <div class="underline-lamkadeh">
                        <div class="underline-lamkadeh-line"></div>
                        <div class="underline-lamkadeh-circle"></div>
                    </div>
                    <div class="mega-menu-content-list-responsive">
                        <ul>
                            <?php
                            for ($col = 1; $col <= 2; $col++) {
                                for ($i = 1; $i <= 7; $i++) {

                                    $item_key = "list{$col}_item{$i}";
                                    $new_key = "list{$col}_item{$i}_new";

                                    if (empty($tab[$item_key])) {
                                        continue;
                                    }
                            ?>
                                    <li>
                                        <a href="#">
                                            <?php echo esc_html($tab[$item_key]); ?>

                                            <?php if (!empty($tab[$new_key]) && $tab[$new_key] === 'yes'): ?>
                                                <span class="badge">
                                                    <?php _e('جدید', 'lamkadeh'); ?>
                                                </span>
                                            <?php endif; ?>
                                        </a>
                                    </li>
                            <?php
                                }
                            }
                            ?>
                        </ul>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
<?php
    }
}
