<?php

namespace Elementor;

if (! defined('ABSPATH')) exit;

class ReviewCustomer extends Widget_Base
{
    public function get_name()
    {
        return 'ReviewCustomer';
    }

    public function get_title()
    {
        return __('نظرات مشتریان لمکده', 'lamkadeh');
    }

    public function get_icon()
    {
        return 'eicon-review';
    }

    public function get_categories()
    {
        return ['lamkadeh'];
    }

    public function register_controls()
    {
        $this->start_controls_section(
            'review_widget_settings',
            [
                'label' => __('تنظیمات نظرات مشتریان لمکده', 'lamkadeh'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'categories_title',
            [
                'label' => __('عنوان دسته بندی ها', 'lamkadeh'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('دسته بندی محصولات', 'lamkadeh'),
            ]
        );

        $this->add_control(
            'categories_title_en',
            [
                'label' => __('عنوان انگلیسی دسته بندی ها', 'lamkadeh'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Categories', 'lamkadeh'),
            ]
        );

        $this->add_control(
            'categories_description',
            [
                'label' => __('توضیحات دسته بندی', 'lamkadeh'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => __('توضیحات کوتاه درباره دسته بندی ها', 'lamkadeh'),
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'customer_name',
            [
                'label' => __('نام مشتری', 'lamkadeh'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('امیرحسین ابی پور', 'lamkadeh'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'customer_role',
            [
                'label' => __('سمت/نقش مشتری', 'lamkadeh'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('مشتری', 'lamkadeh'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'customer_image',
            [
                'label' => __('تصویر مشتری', 'lamkadeh'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'review_text',
            [
                'label' => __('متن نظر', 'lamkadeh'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('من مدت‌ها دنبال یه مبل راحت و شیک می‌گشتم که هم طراحی مدرن داشته باشه و هم کیفیت بالایی. وقتی از این سایت خرید کردم، واقعاً فراتر از انتظارم بود. بسته‌بندی عالی، ارسال به‌موقع و پشتیبانی فوق‌العاده‌ای داشتن. رنگ و جنس کار دقیقاً همون چیزی بود.', 'lamkadeh'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'rating',
            [
                'label' => __('امتیاز', 'lamkadeh'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 5,
                'step' => 1,
                'default' => 5,
            ]
        );

        $this->add_control(
            'reviews_list',
            [
                'label' => __('لیست نظرات', 'lamkadeh'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'customer_name' => __('امیرحسین ابی پور', 'lamkadeh'),
                        'customer_role' => __('مشتری', 'lamkadeh'),
                        'review_text' => __('من مدت‌ها دنبال یه مبل راحت و شیک می‌گشتم که هم طراحی مدرن داشته باشه و هم کیفیت بالایی. وقتی از این سایت خرید کردم، واقعاً فراتر از انتظارم بود.', 'lamkadeh'),
                    ],
                    [
                        'customer_name' => __('فاطمه محمدی', 'lamkadeh'),
                        'customer_role' => __('مشتری ویژه', 'lamkadeh'),
                        'review_text' => __('کیفیت محصولات عالیه، پشتیبانی خیلی خوبی دارن. حتما دوباره خرید می‌کنم.', 'lamkadeh'),
                    ],
                ],
                'title_field' => '{{{ customer_name }}}',
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
?>
        <section class="review-customer container">
            <div class="header-categories-main">
                <div class="title-header-categories-main">
                    <span><?php echo esc_html($settings['categories_title_en']) ?></span>
                    <div class="text-header-categories-main">
                        <span><?php echo esc_html($settings['categories_title']) ?></span>
                        <svg width="64" height="64" viewBox="0 0 64 64" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <g clip-path="url(#clip0_1_3961)">
                                <circle cx="32" cy="32" r="32" transform="matrix(-1 0 0 1 64 0)" fill="#FFD701" />
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M40.5891 12.146H43.4112C44.881 12.146 46.0332 12.146 46.9537 12.2335C47.892 12.3227 48.6602 12.5077 49.3375 12.9227C50.0467 13.3573 50.643 13.9536 51.0776 14.6628C51.4926 15.3401 51.6776 16.1083 51.7668 17.0466C51.8543 17.9671 51.8543 19.1193 51.8543 20.5891V21.5674C51.8543 22.6135 51.8543 23.4338 51.8091 24.0964C51.7631 24.7706 51.668 25.3317 51.4531 25.8506C50.9182 27.1421 49.8921 28.1682 48.6006 28.7031C47.8627 29.0088 47.0222 29.0766 45.8715 29.0964C45.469 29.1033 45.2141 29.1084 45.0197 29.1299C44.8381 29.15 44.7677 29.1795 44.7265 29.2035C44.6831 29.2288 44.6239 29.2748 44.5211 29.4158C44.4098 29.5685 44.2841 29.7794 44.0848 30.1162L43.5879 30.9557C42.8788 32.1538 41.1215 32.1538 40.4124 30.9557L39.9155 30.1162C39.7161 29.7794 39.5904 29.5685 39.4792 29.4158C39.3764 29.2748 39.3172 29.2288 39.2737 29.2035C39.2325 29.1795 39.1622 29.15 38.9806 29.1299C38.7862 29.1084 38.5313 29.1033 38.1288 29.0964C36.9781 29.0766 36.1377 29.0088 35.3998 28.7031C34.1083 28.1682 33.0822 27.1421 32.5472 25.8506C32.3323 25.3317 32.2372 24.7706 32.1912 24.0964C32.146 23.4338 32.146 22.6135 32.146 21.5673L32.146 20.5891C32.146 19.1193 32.146 17.9671 32.2335 17.0466C32.3227 16.1083 32.5077 15.3401 32.9227 14.6628C33.3573 13.9536 33.9536 13.3573 34.6628 12.9227C35.3401 12.5077 36.1083 12.3227 37.0466 12.2335C37.9671 12.146 39.1193 12.146 40.5891 12.146ZM37.1767 13.6023C36.3391 13.682 35.8062 13.8347 35.3813 14.0951C34.8571 14.4163 34.4163 14.8571 34.0951 15.3813C33.8347 15.8062 33.682 16.3391 33.6023 17.1767C33.5217 18.0246 33.521 19.1115 33.521 20.6252V21.5418C33.521 22.619 33.5214 23.3925 33.563 24.0028C33.6042 24.607 33.6836 25.001 33.8175 25.3244C34.213 26.279 34.9714 27.0374 35.926 27.4328C36.3986 27.6286 37.0016 27.7018 38.1525 27.7216L38.1816 27.7221C38.5465 27.7284 38.8662 27.7339 39.1319 27.7633C39.4174 27.7949 39.6967 27.8588 39.965 28.0149C40.2311 28.1697 40.4231 28.3764 40.5904 28.606C40.745 28.8181 40.9039 29.0866 41.0838 29.3906L41.5957 30.2554C41.7723 30.5539 42.2279 30.5539 42.4046 30.2554L42.9165 29.3906C43.0964 29.0866 43.2553 28.8181 43.4099 28.606C43.5772 28.3764 43.7691 28.1697 44.0353 28.0149C44.3036 27.8588 44.5829 27.7949 44.8684 27.7633C45.1341 27.7339 45.4538 27.7284 45.8187 27.7221L45.8478 27.7216C46.9987 27.7018 47.6017 27.6286 48.0744 27.4328C49.029 27.0374 49.7874 26.279 50.1828 25.3244C50.3167 25.001 50.3961 24.607 50.4373 24.0028C50.479 23.3925 50.4793 22.619 50.4793 21.5418V20.6252C50.4793 19.1115 50.4786 18.0246 50.398 17.1767C50.3183 16.3391 50.1656 15.8062 49.9052 15.3813C49.584 14.8571 49.1433 14.4163 48.6191 14.0951C48.1942 13.8347 47.6612 13.682 46.8236 13.6023C45.9757 13.5217 44.8888 13.521 43.3752 13.521H40.6252C39.1115 13.521 38.0246 13.5217 37.1767 13.6023Z" fill="#1D2977" />
                                <path d="M39.2502 21.0835C39.2502 21.5898 38.8398 22.0002 38.3335 22.0002C37.8272 22.0002 37.4168 21.5898 37.4168 21.0835C37.4168 20.5772 37.8272 20.1668 38.3335 20.1668C38.8398 20.1668 39.2502 20.5772 39.2502 21.0835Z" fill="#1D2977" />
                                <path d="M42.9168 21.0835C42.9168 21.5898 42.5064 22.0002 42.0002 22.0002C41.4939 22.0002 41.0835 21.5898 41.0835 21.0835C41.0835 20.5772 41.4939 20.1668 42.0002 20.1668C42.5064 20.1668 42.9168 20.5772 42.9168 21.0835Z" fill="#1D2977" />
                                <path d="M46.5835 21.0835C46.5835 21.5898 46.1731 22.0002 45.6668 22.0002C45.1606 22.0002 44.7502 21.5898 44.7502 21.0835C44.7502 20.5772 45.1606 20.1668 45.6668 20.1668C46.1731 20.1668 46.5835 20.5772 46.5835 21.0835Z" fill="#1D2977" />
                                <circle cx="22" cy="60" r="17" fill="#F7F8FD" fill-opacity="0.64" />
                            </g>
                            <defs>
                                <clipPath id="clip0_1_3961">
                                    <rect width="64" height="64" rx="32" fill="white" />
                                </clipPath>
                            </defs>
                        </svg>
                    </div>
                    <div class="shape-header-categories-main"></div>
                </div>
                <p class="description-header-categories-main">
                    <?php echo wp_kses($settings['categories_description'], [
                        'a' => ['href' => [], 'title' => [], 'target' => []],
                        'br' => [],
                        'strong' => [],
                        'em' => [],
                        'b' => [],
                        'i' => [],
                        'span' => ['class' => []],
                    ]); ?>
                </p>
            </div>

            <div class="review-wrapper">
                <div class="review-wrapper-right">
                    <div class="review-wrapper-right-one"></div>
                    <div class="review-wrapper-right-two"></div>
                    <div class="review-wrapper-right-three"></div>
                    <div class="review-wrapper-right-four">
                        <svg width="77" height="74" viewBox="0 0 77 74" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M17.5 32.8978C15.567 32.8978 14 31.3801 14 29.508C14 27.6359 15.567 26.1182 17.5 26.1182C19.433 26.1182 21 27.6359 21 29.508C21 31.3801 19.433 32.8978 17.5 32.8978Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M45.5 32.8978C43.567 32.8978 42 31.3801 42 29.508C42 27.6359 43.567 26.1182 45.5 26.1182C47.433 26.1182 49 27.6359 49 29.508C49 31.3801 47.433 32.8978 45.5 32.8978Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M59.5 32.8978C57.567 32.8978 56 31.3801 56 29.508C56 27.6359 57.567 26.1182 59.5 26.1182C61.433 26.1182 63 27.6359 63 29.508C63 31.3801 61.433 32.8978 59.5 32.8978Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M3.5 19.3387C1.567 19.3387 6.8819e-07 17.821 6.04698e-07 15.9489C5.21207e-07 14.0768 1.567 12.5591 3.5 12.5591C5.433 12.5591 7 14.0768 7 15.9489C7 17.821 5.433 19.3387 3.5 19.3387Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M17.5 19.3387C15.567 19.3387 14 17.821 14 15.9489C14 14.0768 15.567 12.5591 17.5 12.5591C19.433 12.5591 21 14.0768 21 15.9489C21 17.821 19.433 19.3387 17.5 19.3387Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M31.5 19.3387C29.567 19.3387 28 17.821 28 15.9489C28 14.0768 29.567 12.5591 31.5 12.5591C33.433 12.5591 35 14.0768 35 15.9489C35 17.821 33.433 19.3387 31.5 19.3387Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M59.5 19.3387C57.567 19.3387 56 17.821 56 15.9489C56 14.0768 57.567 12.5591 59.5 12.5591C61.433 12.5591 63 14.0768 63 15.9489C63 17.821 61.433 19.3387 59.5 19.3387Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M73.5 19.3387C71.567 19.3387 70 17.821 70 15.9489C70 14.0768 71.567 12.5591 73.5 12.5591C75.433 12.5591 77 14.0768 77 15.9489C77 17.821 75.433 19.3387 73.5 19.3387Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M3.5 5.77956C1.567 5.77956 8.34915e-08 4.26191 0 2.38978C-8.34915e-08 0.517658 1.567 -0.999997 3.5 -0.999997C5.433 -0.999997 7 0.517658 7 2.38978C7 4.26191 5.433 5.77956 3.5 5.77956Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M31.5 5.77956C29.567 5.77956 28 4.2619 28 2.38978C28 0.517657 29.567 -0.999998 31.5 -0.999998C33.433 -0.999998 35 0.517657 35 2.38978C35 4.2619 33.433 5.77956 31.5 5.77956Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M45.5 5.77956C43.567 5.77956 42 4.2619 42 2.38978C42 0.517656 43.567 -0.999999 45.5 -0.999999C47.433 -0.999999 49 0.517656 49 2.38978C49 4.2619 47.433 5.77956 45.5 5.77956Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M59.5 5.77956C57.567 5.77956 56 4.2619 56 2.38978C56 0.517656 57.567 -0.999999 59.5 -0.999999C61.433 -0.999999 63 0.517655 63 2.38978C63 4.2619 61.433 5.77956 59.5 5.77956Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M73.5 5.77956C71.567 5.77956 70 4.2619 70 2.38978C70 0.517655 71.567 -1 73.5 -1C75.433 -1 77 0.517655 77 2.38978C77 4.2619 75.433 5.77956 73.5 5.77956Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M45.5 19.3387C43.567 19.3387 42 17.821 42 15.9489C42 14.0768 43.567 12.5591 45.5 12.5591C47.433 12.5591 49 14.0768 49 15.9489C49 17.821 47.433 19.3387 45.5 19.3387Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M17.5 5.77956C15.567 5.77956 14 4.2619 14 2.38978C14 0.517658 15.567 -0.999998 17.5 -0.999998C19.433 -0.999998 21 0.517657 21 2.38978C21 4.2619 19.433 5.77956 17.5 5.77956Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M31.5 32.8978C29.567 32.8978 28 31.3801 28 29.508C28 27.6359 29.567 26.1182 31.5 26.1182C33.433 26.1182 35 27.6359 35 29.508C35 31.3801 33.433 32.8978 31.5 32.8978Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M73.5 32.8978C71.567 32.8978 70 31.3801 70 29.508C70 27.6359 71.567 26.1182 73.5 26.1182C75.433 26.1182 77 27.6359 77 29.508C77 31.3801 75.433 32.8978 73.5 32.8978Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M3.5 32.8978C1.567 32.8978 1.29289e-06 31.3801 1.2094e-06 29.508C1.12591e-06 27.6359 1.567 26.1182 3.5 26.1182C5.433 26.1182 7 27.6359 7 29.508C7 31.3801 5.433 32.8978 3.5 32.8978Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M17.5 73.831C15.567 73.831 14 72.3133 14 70.4412C14 68.5691 15.567 67.0514 17.5 67.0514C19.433 67.0514 21 68.5691 21 70.4412C21 72.3133 19.433 73.831 17.5 73.831Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M45.5 73.831C43.567 73.831 42 72.3133 42 70.4412C42 68.5691 43.567 67.0514 45.5 67.0514C47.433 67.0514 49 68.5691 49 70.4412C49 72.3133 47.433 73.831 45.5 73.831Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M59.5 73.831C57.567 73.831 56 72.3133 56 70.4412C56 68.5691 57.567 67.0514 59.5 67.0514C61.433 67.0514 63 68.5691 63 70.4412C63 72.3133 61.433 73.831 59.5 73.831Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M3.5 60.2719C1.567 60.2719 6.8819e-07 58.7542 6.04698e-07 56.8821C5.21207e-07 55.01 1.567 53.4923 3.5 53.4923C5.433 53.4923 7 55.01 7 56.8821C7 58.7542 5.433 60.2719 3.5 60.2719Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M17.5 60.2719C15.567 60.2719 14 58.7542 14 56.8821C14 55.01 15.567 53.4923 17.5 53.4923C19.433 53.4923 21 55.01 21 56.8821C21 58.7542 19.433 60.2719 17.5 60.2719Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M31.5 60.2719C29.567 60.2719 28 58.7542 28 56.8821C28 55.01 29.567 53.4923 31.5 53.4923C33.433 53.4923 35 55.01 35 56.8821C35 58.7542 33.433 60.2719 31.5 60.2719Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M59.5 60.2719C57.567 60.2719 56 58.7542 56 56.8821C56 55.01 57.567 53.4923 59.5 53.4923C61.433 53.4923 63 55.01 63 56.8821C63 58.7542 61.433 60.2719 59.5 60.2719Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M73.5 60.2719C71.567 60.2719 70 58.7542 70 56.8821C70 55.01 71.567 53.4923 73.5 53.4923C75.433 53.4923 77 55.01 77 56.8821C77 58.7542 75.433 60.2719 73.5 60.2719Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M3.5 46.7127C1.567 46.7127 8.34915e-08 45.1951 0 43.323C-8.34915e-08 41.4508 1.567 39.9332 3.5 39.9332C5.433 39.9332 7 41.4508 7 43.323C7 45.1951 5.433 46.7127 3.5 46.7127Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M31.5 46.7127C29.567 46.7127 28 45.1951 28 43.323C28 41.4508 29.567 39.9332 31.5 39.9332C33.433 39.9332 35 41.4508 35 43.323C35 45.1951 33.433 46.7127 31.5 46.7127Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M45.5 46.7127C43.567 46.7127 42 45.1951 42 43.323C42 41.4508 43.567 39.9332 45.5 39.9332C47.433 39.9332 49 41.4508 49 43.323C49 45.1951 47.433 46.7127 45.5 46.7127Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M59.5 46.7127C57.567 46.7127 56 45.1951 56 43.323C56 41.4508 57.567 39.9332 59.5 39.9332C61.433 39.9332 63 41.4508 63 43.323C63 45.1951 61.433 46.7127 59.5 46.7127Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M73.5 46.7127C71.567 46.7127 70 45.1951 70 43.323C70 41.4508 71.567 39.9332 73.5 39.9332C75.433 39.9332 77 41.4508 77 43.323C77 45.1951 75.433 46.7127 73.5 46.7127Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M45.5 60.2719C43.567 60.2719 42 58.7542 42 56.8821C42 55.01 43.567 53.4923 45.5 53.4923C47.433 53.4923 49 55.01 49 56.8821C49 58.7542 47.433 60.2719 45.5 60.2719Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M17.5 46.7127C15.567 46.7127 14 45.1951 14 43.323C14 41.4508 15.567 39.9332 17.5 39.9332C19.433 39.9332 21 41.4508 21 43.323C21 45.1951 19.433 46.7127 17.5 46.7127Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M31.5 73.831C29.567 73.831 28 72.3133 28 70.4412C28 68.5691 29.567 67.0514 31.5 67.0514C33.433 67.0514 35 68.5691 35 70.4412C35 72.3133 33.433 73.831 31.5 73.831Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M73.5 73.831C71.567 73.831 70 72.3133 70 70.4412C70 68.5691 71.567 67.0514 73.5 67.0514C75.433 67.0514 77 68.5691 77 70.4412C77 72.3133 75.433 73.831 73.5 73.831Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M3.5 73.831C1.567 73.831 1.29289e-06 72.3133 1.2094e-06 70.4412C1.12591e-06 68.5691 1.567 67.0514 3.5 67.0514C5.433 67.0514 7 68.5691 7 70.4412C7 72.3133 5.433 73.831 3.5 73.831Z" fill="#F7F8FD" fill-opacity="0.64" />
                        </svg>
                    </div>
                </div>
                <div class="review-wrapper-center">
                    <div class="review-wrapper-center-content">
                        <div class="swiper">
                            <div class="swiper-wrapper">
                                <?php if ($settings['reviews_list']) : ?>
                                    <?php foreach ($settings['reviews_list'] as $review) : ?>
                                        <div class="swiper-slide">
                                            <div class="review-wrapper-center-content-review">
                                                <div class="review-wrapper-center-content-review-header">
                                                    <div class="review-wrapper-center-content-review-header-right">
                                                        <img src="<?php echo esc_url($review['customer_image']['url']); ?>" alt="<?php echo esc_attr($review['customer_name']); ?>">
                                                        <div>
                                                            <span><?php echo esc_html($review['customer_name']); ?></span>
                                                            <span><?php echo esc_html($review['customer_role']); ?></span>
                                                        </div>
                                                    </div>
                                                    <div class="review-wrapper-center-content-review-header-left">
                                                        <span>“</span>
                                                        <span>“</span>
                                                    </div>
                                                </div>
                                                <div class="underline-lamkadeh">
                                                    <div class="underline-lamkadeh-line"></div>
                                                    <div class="underline-lamkadeh-circle"></div>
                                                </div>
                                                <div class="review-wrapper-center-content-review-bottom">
                                                    <p>
                                                        من مدت‌ها دنبال یه مبل راحت و شیک می‌گشتم که هم طراحی مدرن داشته باشه و هم کیفیت بالایی. وقتی از این سایت خرید کردم، واقعاً فراتر از انتظارم بود. بسته‌بندی عالی، ارسال به‌موقع و پشتیبانی فوق‌العاده‌ای داشتن. رنگ و جنس کار دقیقاً همون چیزی بود.
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="review-wrapper-center-pagination">
                        <div class="review-wrapper-center-pagination-right">
                            <svg width="27" height="14" viewBox="0 0 27 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M19.2797 12.8875C19.2797 12.6975 19.3497 12.5075 19.4997 12.3575L25.0397 6.8175L19.4997 1.2775C19.2097 0.987501 19.2097 0.507501 19.4997 0.217501C19.7897 -0.0724991 20.2697 -0.0724991 20.5597 0.217501L26.6297 6.2875C26.9197 6.5775 26.9197 7.0575 26.6297 7.3475L20.5597 13.4175C20.2697 13.7075 19.7897 13.7075 19.4997 13.4175C19.3497 13.2775 19.2797 13.0775 19.2797 12.8875Z" fill="#F7F8FD" />
                                <path d="M7.81685e-05 6.81738C7.81864e-05 6.40738 0.340078 6.06738 0.750078 6.06738L25.5801 6.06738C25.9901 6.06738 26.3301 6.40738 26.3301 6.81738C26.3301 7.22738 25.9901 7.56738 25.5801 7.56738L0.750078 7.56738C0.340078 7.56738 7.81506e-05 7.22738 7.81685e-05 6.81738Z" fill="#F7F8FD" />
                            </svg>
                        </div>
                        <div class="review-wrapper-center-pagination-left">
                            <svg width="27" height="14" viewBox="0 0 27 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M7.5675 12.8875C7.5675 12.6975 7.4975 12.5075 7.3475 12.3575L1.8075 6.8175L7.3475 1.2775C7.6375 0.987501 7.6375 0.507501 7.3475 0.217501C7.0575 -0.0724991 6.5775 -0.0724991 6.2875 0.217501L0.2175 6.2875C-0.0724997 6.5775 -0.0724997 7.0575 0.2175 7.3475L6.2875 13.4175C6.5775 13.7075 7.0575 13.7075 7.3475 13.4175C7.4975 13.2775 7.5675 13.0775 7.5675 12.8875Z" fill="#F7F8FD" />
                                <path d="M26.8471 6.81738C26.8471 6.40738 26.5071 6.06738 26.0971 6.06738L1.26709 6.06738C0.85709 6.06738 0.51709 6.40738 0.51709 6.81738C0.51709 7.22738 0.85709 7.56738 1.26709 7.56738L26.0971 7.56738C26.5071 7.56738 26.8471 7.22738 26.8471 6.81738Z" fill="#F7F8FD" />
                            </svg>
                        </div>
                    </div>
                </div>
                <div class="review-wrapper-left">
                    <div class="review-wrapper-left-one"></div>
                    <div class="review-wrapper-left-two"></div>
                    <div class="review-wrapper-left-three">
                        <svg width="77" height="74" viewBox="0 0 77 74" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M17.5 32.8978C15.567 32.8978 14 31.3801 14 29.508C14 27.6359 15.567 26.1182 17.5 26.1182C19.433 26.1182 21 27.6359 21 29.508C21 31.3801 19.433 32.8978 17.5 32.8978Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M45.5 32.8978C43.567 32.8978 42 31.3801 42 29.508C42 27.6359 43.567 26.1182 45.5 26.1182C47.433 26.1182 49 27.6359 49 29.508C49 31.3801 47.433 32.8978 45.5 32.8978Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M59.5 32.8978C57.567 32.8978 56 31.3801 56 29.508C56 27.6359 57.567 26.1182 59.5 26.1182C61.433 26.1182 63 27.6359 63 29.508C63 31.3801 61.433 32.8978 59.5 32.8978Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M3.5 19.3387C1.567 19.3387 6.8819e-07 17.821 6.04698e-07 15.9489C5.21207e-07 14.0768 1.567 12.5591 3.5 12.5591C5.433 12.5591 7 14.0768 7 15.9489C7 17.821 5.433 19.3387 3.5 19.3387Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M17.5 19.3387C15.567 19.3387 14 17.821 14 15.9489C14 14.0768 15.567 12.5591 17.5 12.5591C19.433 12.5591 21 14.0768 21 15.9489C21 17.821 19.433 19.3387 17.5 19.3387Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M31.5 19.3387C29.567 19.3387 28 17.821 28 15.9489C28 14.0768 29.567 12.5591 31.5 12.5591C33.433 12.5591 35 14.0768 35 15.9489C35 17.821 33.433 19.3387 31.5 19.3387Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M59.5 19.3387C57.567 19.3387 56 17.821 56 15.9489C56 14.0768 57.567 12.5591 59.5 12.5591C61.433 12.5591 63 14.0768 63 15.9489C63 17.821 61.433 19.3387 59.5 19.3387Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M73.5 19.3387C71.567 19.3387 70 17.821 70 15.9489C70 14.0768 71.567 12.5591 73.5 12.5591C75.433 12.5591 77 14.0768 77 15.9489C77 17.821 75.433 19.3387 73.5 19.3387Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M3.5 5.77956C1.567 5.77956 8.34915e-08 4.26191 0 2.38978C-8.34915e-08 0.517658 1.567 -0.999997 3.5 -0.999997C5.433 -0.999997 7 0.517658 7 2.38978C7 4.26191 5.433 5.77956 3.5 5.77956Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M31.5 5.77956C29.567 5.77956 28 4.2619 28 2.38978C28 0.517657 29.567 -0.999998 31.5 -0.999998C33.433 -0.999998 35 0.517657 35 2.38978C35 4.2619 33.433 5.77956 31.5 5.77956Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M45.5 5.77956C43.567 5.77956 42 4.2619 42 2.38978C42 0.517656 43.567 -0.999999 45.5 -0.999999C47.433 -0.999999 49 0.517656 49 2.38978C49 4.2619 47.433 5.77956 45.5 5.77956Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M59.5 5.77956C57.567 5.77956 56 4.2619 56 2.38978C56 0.517656 57.567 -0.999999 59.5 -0.999999C61.433 -0.999999 63 0.517655 63 2.38978C63 4.2619 61.433 5.77956 59.5 5.77956Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M73.5 5.77956C71.567 5.77956 70 4.2619 70 2.38978C70 0.517655 71.567 -1 73.5 -1C75.433 -1 77 0.517655 77 2.38978C77 4.2619 75.433 5.77956 73.5 5.77956Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M45.5 19.3387C43.567 19.3387 42 17.821 42 15.9489C42 14.0768 43.567 12.5591 45.5 12.5591C47.433 12.5591 49 14.0768 49 15.9489C49 17.821 47.433 19.3387 45.5 19.3387Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M17.5 5.77956C15.567 5.77956 14 4.2619 14 2.38978C14 0.517658 15.567 -0.999998 17.5 -0.999998C19.433 -0.999998 21 0.517657 21 2.38978C21 4.2619 19.433 5.77956 17.5 5.77956Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M31.5 32.8978C29.567 32.8978 28 31.3801 28 29.508C28 27.6359 29.567 26.1182 31.5 26.1182C33.433 26.1182 35 27.6359 35 29.508C35 31.3801 33.433 32.8978 31.5 32.8978Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M73.5 32.8978C71.567 32.8978 70 31.3801 70 29.508C70 27.6359 71.567 26.1182 73.5 26.1182C75.433 26.1182 77 27.6359 77 29.508C77 31.3801 75.433 32.8978 73.5 32.8978Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M3.5 32.8978C1.567 32.8978 1.29289e-06 31.3801 1.2094e-06 29.508C1.12591e-06 27.6359 1.567 26.1182 3.5 26.1182C5.433 26.1182 7 27.6359 7 29.508C7 31.3801 5.433 32.8978 3.5 32.8978Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M17.5 73.831C15.567 73.831 14 72.3133 14 70.4412C14 68.5691 15.567 67.0514 17.5 67.0514C19.433 67.0514 21 68.5691 21 70.4412C21 72.3133 19.433 73.831 17.5 73.831Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M45.5 73.831C43.567 73.831 42 72.3133 42 70.4412C42 68.5691 43.567 67.0514 45.5 67.0514C47.433 67.0514 49 68.5691 49 70.4412C49 72.3133 47.433 73.831 45.5 73.831Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M59.5 73.831C57.567 73.831 56 72.3133 56 70.4412C56 68.5691 57.567 67.0514 59.5 67.0514C61.433 67.0514 63 68.5691 63 70.4412C63 72.3133 61.433 73.831 59.5 73.831Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M3.5 60.2719C1.567 60.2719 6.8819e-07 58.7542 6.04698e-07 56.8821C5.21207e-07 55.01 1.567 53.4923 3.5 53.4923C5.433 53.4923 7 55.01 7 56.8821C7 58.7542 5.433 60.2719 3.5 60.2719Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M17.5 60.2719C15.567 60.2719 14 58.7542 14 56.8821C14 55.01 15.567 53.4923 17.5 53.4923C19.433 53.4923 21 55.01 21 56.8821C21 58.7542 19.433 60.2719 17.5 60.2719Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M31.5 60.2719C29.567 60.2719 28 58.7542 28 56.8821C28 55.01 29.567 53.4923 31.5 53.4923C33.433 53.4923 35 55.01 35 56.8821C35 58.7542 33.433 60.2719 31.5 60.2719Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M59.5 60.2719C57.567 60.2719 56 58.7542 56 56.8821C56 55.01 57.567 53.4923 59.5 53.4923C61.433 53.4923 63 55.01 63 56.8821C63 58.7542 61.433 60.2719 59.5 60.2719Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M73.5 60.2719C71.567 60.2719 70 58.7542 70 56.8821C70 55.01 71.567 53.4923 73.5 53.4923C75.433 53.4923 77 55.01 77 56.8821C77 58.7542 75.433 60.2719 73.5 60.2719Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M3.5 46.7127C1.567 46.7127 8.34915e-08 45.1951 0 43.323C-8.34915e-08 41.4508 1.567 39.9332 3.5 39.9332C5.433 39.9332 7 41.4508 7 43.323C7 45.1951 5.433 46.7127 3.5 46.7127Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M31.5 46.7127C29.567 46.7127 28 45.1951 28 43.323C28 41.4508 29.567 39.9332 31.5 39.9332C33.433 39.9332 35 41.4508 35 43.323C35 45.1951 33.433 46.7127 31.5 46.7127Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M45.5 46.7127C43.567 46.7127 42 45.1951 42 43.323C42 41.4508 43.567 39.9332 45.5 39.9332C47.433 39.9332 49 41.4508 49 43.323C49 45.1951 47.433 46.7127 45.5 46.7127Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M59.5 46.7127C57.567 46.7127 56 45.1951 56 43.323C56 41.4508 57.567 39.9332 59.5 39.9332C61.433 39.9332 63 41.4508 63 43.323C63 45.1951 61.433 46.7127 59.5 46.7127Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M73.5 46.7127C71.567 46.7127 70 45.1951 70 43.323C70 41.4508 71.567 39.9332 73.5 39.9332C75.433 39.9332 77 41.4508 77 43.323C77 45.1951 75.433 46.7127 73.5 46.7127Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M45.5 60.2719C43.567 60.2719 42 58.7542 42 56.8821C42 55.01 43.567 53.4923 45.5 53.4923C47.433 53.4923 49 55.01 49 56.8821C49 58.7542 47.433 60.2719 45.5 60.2719Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M17.5 46.7127C15.567 46.7127 14 45.1951 14 43.323C14 41.4508 15.567 39.9332 17.5 39.9332C19.433 39.9332 21 41.4508 21 43.323C21 45.1951 19.433 46.7127 17.5 46.7127Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M31.5 73.831C29.567 73.831 28 72.3133 28 70.4412C28 68.5691 29.567 67.0514 31.5 67.0514C33.433 67.0514 35 68.5691 35 70.4412C35 72.3133 33.433 73.831 31.5 73.831Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M73.5 73.831C71.567 73.831 70 72.3133 70 70.4412C70 68.5691 71.567 67.0514 73.5 67.0514C75.433 67.0514 77 68.5691 77 70.4412C77 72.3133 75.433 73.831 73.5 73.831Z" fill="#F7F8FD" fill-opacity="0.64" />
                            <path d="M3.5 73.831C1.567 73.831 1.29289e-06 72.3133 1.2094e-06 70.4412C1.12591e-06 68.5691 1.567 67.0514 3.5 67.0514C5.433 67.0514 7 68.5691 7 70.4412C7 72.3133 5.433 73.831 3.5 73.831Z" fill="#F7F8FD" fill-opacity="0.64" />
                        </svg>
                    </div>
                    <div class="review-wrapper-left-four"></div>
                </div>
            </div>
        </section>
<?php
    }
}
