<?php

namespace Elementor;

if (!defined('ABSPATH'))
    exit;

class BannerAmazing extends Widget_Base
{
    public function get_name()
    {
        return 'BannerAmazing';
    }

    public function get_title()
    {
        return __('بنر شگفت انگیز لمکده', 'lamkadeh');
    }

    public function get_icon()
    {
        return 'eicon-banner';
    }

    public function get_categories()
    {
        return ['lamkadeh'];
    }

    protected function register_controls()
    {
        // بخش محتوا
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('محتوا', 'lamkadeh'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        // تصویر بنر
        $this->add_control(
            'banner_image',
            [
                'label' => __('تصویر بنر', 'lamkadeh'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => get_template_directory_uri() . '/assets/images/banners/chair.webp',
                ],
            ]
        );

        // درصد تخفیف
        $this->add_control(
            'discount_percent',
            [
                'label' => __('درصد تخفیف', 'lamkadeh'),
                'type' => Controls_Manager::TEXT,
                'default' => '۳۲',
                'placeholder' => '۳۲',
            ]
        );

        // عنوان اصلی
        $this->add_control(
            'main_title',
            [
                'label' => __('عنوان اصلی', 'lamkadeh'),
                'type' => Controls_Manager::TEXT,
                'default' => 'صندلی های راحـــــــــــــــــتی',
                'placeholder' => __('عنوان اصلی را وارد کنید', 'lamkadeh'),
            ]
        );

        // زیرعنوان (ویرایشگر وردپرسی WYSIWYG)
        $this->add_control(
            'subtitle',
            [
                'label' => __('زیرعنوان', 'lamkadeh'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => '۱۵ خرداد الی ۲۳ مرداد',
                'placeholder' => __('زیرعنوان را وارد کنید', 'lamkadeh'),
            ]
        );

        // عنوان هدر سمت چپ
        $this->add_control(
            'left_header_title',
            [
                'label' => __('عنوان هدر سمت چپ', 'lamkadeh'),
                'type' => Controls_Manager::TEXT,
                'default' => 'جشــــــنواره داغ تابستانی!',
                'placeholder' => __('عنوان هدر سمت چپ را وارد کنید', 'lamkadeh'),
            ]
        );

        // متن هدر سمت چپ
        $this->add_control(
            'left_header_text',
            [
                'label' => __('متن هدر سمت چپ', 'lamkadeh'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => 'فرصت محدوده! پس همین حالا خرید کن و از این <strong>تخــفیف‌های شگـــــــــــــفت‌انگیز</strong> لذت ببر!',
                'placeholder' => __('متن هدر سمت چپ را وارد کنید', 'lamkadeh'),
            ]
        );

        // متن دکمه
        $this->add_control(
            'button_text',
            [
                'label' => __('متن دکمه', 'lamkadeh'),
                'type' => Controls_Manager::TEXT,
                'default' => 'مشاهده و خرید',
                'placeholder' => __('متن دکمه را وارد کنید', 'lamkadeh'),
            ]
        );

        // لینک دکمه
        $this->add_control(
            'button_link',
            [
                'label' => __('لینک دکمه', 'lamkadeh'),
                'type' => Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', 'lamkadeh'),
                'default' => [
                    'url' => '#',
                ],
            ]
        );

        // نمایش تایمر
        $this->add_control(
            'show_timer',
            [
                'label' => __('نمایش تایمر', 'lamkadeh'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('نمایش', 'lamkadeh'),
                'label_off' => __('مخفی', 'lamkadeh'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        // تاریخ پایان
        $this->add_control(
            'end_date',
            [
                'label' => __('تاریخ پایان پیشنهاد', 'lamkadeh'),
                'type' => Controls_Manager::DATE_TIME,
                'default' => date('Y-m-d H:i', strtotime('+4 days')),
                'condition' => [
                    'show_timer' => 'yes'
                ],
            ]
        );

        $this->end_controls_section();

        // بخش پالت رنگ
        $this->start_controls_section(
            'color_palette_section',
            [
                'label' => __('پالت رنگ', 'lamkadeh'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'color_palette_enbale',
            [
                'label'        => __('آیا پالت رنگی نمایش داده شود؟', 'lamkadeh'),
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'label_on'     => __('بله', 'lamkadeh'),
                'label_off'    => __('خیر', 'lamkadeh'),
                'return_value' => 'yes',
                'default'      => 'no',
            ]
        );

        $this->add_control(
            'color_palette_1',
            [
                'label' => __('رنگ 1', 'lamkadeh'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#3E2F23',
                'condition' => [
                    'color_palette_enbale' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'color_palette_2',
            [
                'label' => __('رنگ 2', 'lamkadeh'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#7A8450',
                'condition' => [
                    'color_palette_enbale' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'color_palette_3',
            [
                'label' => __('رنگ 3', 'lamkadeh'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#508481',
                'condition' => [
                    'color_palette_enbale' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'color_palette_4',
            [
                'label' => __('رنگ 4', 'lamkadeh'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#1D2977',
                'condition' => [
                    'color_palette_enbale' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $button_url = !empty($settings['button_link']['url']) ? $settings['button_link']['url'] : '#';
        $button_external = !empty($settings['button_link']['is_external']) ? 'target="_blank"' : '';
        $button_nofollow = !empty($settings['button_link']['nofollow']) ? 'rel="nofollow"' : '';

        $time_remaining = array('days' => '04', 'hours' => '10', 'minutes' => '45', 'seconds' => '00');
        if ($settings['show_timer'] === 'yes' && !empty($settings['end_date'])) {
            $end_date = strtotime($settings['end_date']);
            $current_date = current_time('timestamp');
            $diff = $end_date - $current_date;

            if ($diff > 0) {
                $time_remaining = array(
                    'days' => str_pad(floor($diff / (60 * 60 * 24)), 2, '0', STR_PAD_LEFT),
                    'hours' => str_pad(floor(($diff % (60 * 60 * 24)) / (60 * 60)), 2, '0', STR_PAD_LEFT),
                    'minutes' => str_pad(floor(($diff % (60 * 60)) / 60), 2, '0', STR_PAD_LEFT),
                    'seconds' => str_pad($diff % 60, 2, '0', STR_PAD_LEFT),
                );
            }
        }

        $color_1 = $settings['color_palette_1'];
        $color_2 = $settings['color_palette_2'];
        $color_3 = $settings['color_palette_3'];
        $color_4 = $settings['color_palette_4'];
?>
        <section class="banner-amazing container">
            <div class="banner-amazing-shape"></div>
            <div class="banner-amazing-image">
                <?php
                if ($settings["color_palette_enbale"] === "yes") {
                ?>
                    <div class="color-palette">
                        <div class="color-palette-circle">
                            <div class="color-palette-circle-dot" style="background-color: <?php echo esc_attr($color_1); ?>"></div>
                            <div class="color-palette-circle-dot" style="background-color: <?php echo esc_attr($color_2); ?>"></div>
                            <div class="color-palette-circle-dot" style="background-color: <?php echo esc_attr($color_3); ?>"></div>
                            <div class="color-palette-circle-dot" style="background-color: <?php echo esc_attr($color_4); ?>"></div>
                        </div>
                        <svg class="line-image" width="77" height="41" viewBox="0 0 77 41" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path d="M0.376465 0.329102L31.7908 36.2312C34.0694 38.8353 37.3613 40.3291 40.8217 40.3291H76.8765"
                                stroke="#F7F8FD" />
                        </svg>
                        <svg class="circle-selector-image" width="22" height="22" viewBox="0 0 22 22" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <circle cx="11" cy="11" r="4" fill="#F7F8FD" />
                            <circle cx="11" cy="11" r="10.5" stroke="#F7F8FD" />
                        </svg>
                    </div>
                <?php } ?>
                <img src="<?php echo esc_url($settings['banner_image']['url']); ?>"
                    alt="<?php echo esc_attr(get_bloginfo('name')); ?>">
                <div class="banner-amazing-image-circle"></div>

                <svg width="91" height="88" viewBox="0 0 91 88" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path
                        d="M70.3182 39.8633C72.6026 39.8633 74.4545 38.0785 74.4545 35.8769C74.4545 33.6753 72.6026 31.8906 70.3182 31.8906C68.0337 31.8906 66.1818 33.6753 66.1818 35.8769C66.1818 38.0785 68.0337 39.8633 70.3182 39.8633Z"
                        fill="#F7F8FD" fill-opacity="0.4" />
                    <path
                        d="M37.2273 39.8633C39.5117 39.8633 41.3636 38.0785 41.3636 35.8769C41.3636 33.6753 39.5117 31.8906 37.2273 31.8906C34.9428 31.8906 33.0909 33.6753 33.0909 35.8769C33.0909 38.0785 34.9428 39.8633 37.2273 39.8633Z"
                        fill="#F7F8FD" fill-opacity="0.4" />
                    <path
                        d="M20.6818 39.8632C22.9663 39.8632 24.8182 38.0785 24.8182 35.8769C24.8182 33.6753 22.9663 31.8906 20.6818 31.8906C18.3974 31.8906 16.5455 33.6753 16.5455 35.8769C16.5455 38.0785 18.3974 39.8632 20.6818 39.8632Z"
                        fill="#F7F8FD" fill-opacity="0.4" />
                    <path
                        d="M86.8636 23.9179C89.1481 23.9179 91 22.1332 91 19.9316C91 17.73 89.1481 15.9453 86.8636 15.9453C84.5792 15.9453 82.7273 17.73 82.7273 19.9316C82.7273 22.1332 84.5792 23.9179 86.8636 23.9179Z"
                        fill="#F7F8FD" fill-opacity="0.4" />
                    <path
                        d="M70.3182 23.9179C72.6026 23.9179 74.4545 22.1332 74.4545 19.9316C74.4545 17.73 72.6026 15.9453 70.3182 15.9453C68.0337 15.9453 66.1818 17.73 66.1818 19.9316C66.1818 22.1332 68.0337 23.9179 70.3182 23.9179Z"
                        fill="#F7F8FD" fill-opacity="0.4" />
                    <path
                        d="M53.7727 23.9179C56.0572 23.9179 57.9091 22.1332 57.9091 19.9316C57.9091 17.73 56.0572 15.9453 53.7727 15.9453C51.4883 15.9453 49.6364 17.73 49.6364 19.9316C49.6364 22.1332 51.4883 23.9179 53.7727 23.9179Z"
                        fill="#F7F8FD" fill-opacity="0.4" />
                    <path
                        d="M20.6818 23.9179C22.9663 23.9179 24.8182 22.1332 24.8182 19.9316C24.8182 17.73 22.9663 15.9453 20.6818 15.9453C18.3974 15.9453 16.5455 17.73 16.5455 19.9316C16.5455 22.1332 18.3974 23.9179 20.6818 23.9179Z"
                        fill="#F7F8FD" fill-opacity="0.4" />
                    <path
                        d="M4.13636 23.9179C6.42081 23.9179 8.27274 22.1332 8.27274 19.9316C8.27274 17.73 6.42081 15.9453 4.13636 15.9453C1.85191 15.9453 0 17.73 0 19.9316C0 22.1332 1.85191 23.9179 4.13636 23.9179Z"
                        fill="#F7F8FD" fill-opacity="0.4" />
                    <path
                        d="M86.8636 7.97265C89.1481 7.97265 91 6.18791 91 3.98633C91 1.78474 89.1481 3.62419e-06 86.8636 3.5268e-06C84.5792 3.42941e-06 82.7273 1.78474 82.7273 3.98633C82.7273 6.18791 84.5792 7.97265 86.8636 7.97265Z"
                        fill="#F7F8FD" fill-opacity="0.4" />
                    <path
                        d="M53.7727 7.97265C56.0572 7.97265 57.9091 6.18791 57.9091 3.98633C57.9091 1.78474 56.0572 2.21347e-06 53.7727 2.11608e-06C51.4883 2.01869e-06 49.6364 1.78474 49.6364 3.98633C49.6364 6.18791 51.4883 7.97265 53.7727 7.97265Z"
                        fill="#F7F8FD" fill-opacity="0.4" />
                    <path
                        d="M37.2273 7.97265C39.5117 7.97265 41.3636 6.18791 41.3636 3.98633C41.3636 1.78474 39.5117 1.50811e-06 37.2273 1.41072e-06C34.9428 1.31333e-06 33.0909 1.78474 33.0909 3.98632C33.0909 6.18791 34.9428 7.97265 37.2273 7.97265Z"
                        fill="#F7F8FD" fill-opacity="0.4" />
                    <path
                        d="M20.6818 7.97265C22.9663 7.97265 24.8182 6.18791 24.8182 3.98632C24.8182 1.78474 22.9663 8.02749e-07 20.6818 7.05359e-07C18.3974 6.07969e-07 16.5455 1.78474 16.5455 3.98632C16.5455 6.18791 18.3974 7.97265 20.6818 7.97265Z"
                        fill="#F7F8FD" fill-opacity="0.4" />
                    <path
                        d="M4.13636 7.97265C6.42081 7.97265 8.27274 6.18791 8.27274 3.98632C8.27274 1.78474 6.42081 9.73899e-08 4.13636 0C1.85191 -9.73899e-08 7.62939e-06 1.78474 7.62939e-06 3.98632C7.62939e-06 6.18791 1.85191 7.97265 4.13636 7.97265Z"
                        fill="#F7F8FD" fill-opacity="0.4" />
                    <path
                        d="M37.2273 23.9179C39.5117 23.9179 41.3636 22.1332 41.3636 19.9316C41.3636 17.73 39.5117 15.9453 37.2273 15.9453C34.9428 15.9453 33.0909 17.73 33.0909 19.9316C33.0909 22.1332 34.9428 23.9179 37.2273 23.9179Z"
                        fill="#F7F8FD" fill-opacity="0.4" />
                    <path
                        d="M70.3182 7.97265C72.6026 7.97265 74.4545 6.18791 74.4545 3.98633C74.4545 1.78474 72.6026 2.91883e-06 70.3182 2.82144e-06C68.0337 2.72405e-06 66.1818 1.78474 66.1818 3.98633C66.1818 6.18791 68.0337 7.97265 70.3182 7.97265Z"
                        fill="#F7F8FD" fill-opacity="0.4" />
                    <path
                        d="M53.7727 39.8633C56.0572 39.8633 57.9091 38.0785 57.9091 35.8769C57.9091 33.6753 56.0572 31.8906 53.7727 31.8906C51.4883 31.8906 49.6364 33.6753 49.6364 35.8769C49.6364 38.0785 51.4883 39.8633 53.7727 39.8633Z"
                        fill="#F7F8FD" fill-opacity="0.4" />
                    <path
                        d="M4.13636 39.8632C6.42081 39.8632 8.27274 38.0785 8.27274 35.8769C8.27274 33.6753 6.42081 31.8906 4.13636 31.8906C1.85191 31.8906 0 33.6753 0 35.8769C0 38.0785 1.85191 39.8632 4.13636 39.8632Z"
                        fill="#F7F8FD" fill-opacity="0.4" />
                    <path
                        d="M86.8636 39.8633C89.1481 39.8633 91 38.0785 91 35.8769C91 33.6753 89.1481 31.8906 86.8636 31.8906C84.5792 31.8906 82.7273 33.6753 82.7273 35.8769C82.7273 38.0785 84.5792 39.8633 86.8636 39.8633Z"
                        fill="#F7F8FD" fill-opacity="0.4" />
                    <path
                        d="M70.3182 88C72.6026 88 74.4545 86.2153 74.4545 84.0137C74.4545 81.8121 72.6026 80.0274 70.3182 80.0274C68.0337 80.0274 66.1818 81.8121 66.1818 84.0137C66.1818 86.2153 68.0337 88 70.3182 88Z"
                        fill="#F7F8FD" fill-opacity="0.4" />
                    <path
                        d="M37.2273 88C39.5117 88 41.3636 86.2153 41.3636 84.0137C41.3636 81.8121 39.5117 80.0274 37.2273 80.0274C34.9428 80.0274 33.0909 81.8121 33.0909 84.0137C33.0909 86.2153 34.9428 88 37.2273 88Z"
                        fill="#F7F8FD" fill-opacity="0.4" />
                    <path
                        d="M20.6818 88C22.9663 88 24.8182 86.2153 24.8182 84.0137C24.8182 81.8121 22.9663 80.0274 20.6818 80.0274C18.3974 80.0274 16.5455 81.8121 16.5455 84.0137C16.5455 86.2153 18.3974 88 20.6818 88Z"
                        fill="#F7F8FD" fill-opacity="0.4" />
                    <path
                        d="M86.8636 72.0547C89.1481 72.0547 91 70.27 91 68.0684C91 65.8668 89.1481 64.0821 86.8636 64.0821C84.5792 64.0821 82.7273 65.8668 82.7273 68.0684C82.7273 70.27 84.5792 72.0547 86.8636 72.0547Z"
                        fill="#F7F8FD" fill-opacity="0.4" />
                    <path
                        d="M70.3182 72.0547C72.6026 72.0547 74.4545 70.27 74.4545 68.0684C74.4545 65.8668 72.6026 64.0821 70.3182 64.0821C68.0337 64.0821 66.1818 65.8668 66.1818 68.0684C66.1818 70.27 68.0337 72.0547 70.3182 72.0547Z"
                        fill="#F7F8FD" fill-opacity="0.4" />
                    <path
                        d="M53.7727 72.0547C56.0572 72.0547 57.9091 70.27 57.9091 68.0684C57.9091 65.8668 56.0572 64.0821 53.7727 64.0821C51.4883 64.0821 49.6364 65.8668 49.6364 68.0684C49.6364 70.27 51.4883 72.0547 53.7727 72.0547Z"
                        fill="#F7F8FD" fill-opacity="0.4" />
                    <path
                        d="M20.6818 72.0547C22.9663 72.0547 24.8182 70.27 24.8182 68.0684C24.8182 65.8668 22.9663 64.0821 20.6818 64.0821C18.3974 64.0821 16.5455 65.8668 16.5455 68.0684C16.5455 70.27 18.3974 72.0547 20.6818 72.0547Z"
                        fill="#F7F8FD" fill-opacity="0.4" />
                    <path
                        d="M4.13636 72.0547C6.42081 72.0547 8.27274 70.27 8.27274 68.0684C8.27274 65.8668 6.42081 64.0821 4.13636 64.0821C1.85191 64.0821 0 65.8668 0 68.0684C0 70.27 1.85191 72.0547 4.13636 72.0547Z"
                        fill="#F7F8FD" fill-opacity="0.4" />
                    <path
                        d="M86.8636 56.1094C89.1481 56.1094 91 54.3247 91 52.1231C91 49.9215 89.1481 48.1368 86.8636 48.1368C84.5792 48.1368 82.7273 49.9215 82.7273 52.1231C82.7273 54.3247 84.5792 56.1094 86.8636 56.1094Z"
                        fill="#F7F8FD" fill-opacity="0.4" />
                    <path
                        d="M53.7727 56.1094C56.0572 56.1094 57.9091 54.3247 57.9091 52.1231C57.9091 49.9215 56.0572 48.1368 53.7727 48.1368C51.4883 48.1368 49.6364 49.9215 49.6364 52.1231C49.6364 54.3247 51.4883 56.1094 53.7727 56.1094Z"
                        fill="#F7F8FD" fill-opacity="0.4" />
                    <path
                        d="M37.2273 56.1094C39.5117 56.1094 41.3636 54.3247 41.3636 52.1231C41.3636 49.9215 39.5117 48.1368 37.2273 48.1368C34.9428 48.1368 33.0909 49.9215 33.0909 52.1231C33.0909 54.3247 34.9428 56.1094 37.2273 56.1094Z"
                        fill="#F7F8FD" fill-opacity="0.4" />
                    <path
                        d="M20.6818 56.1094C22.9663 56.1094 24.8182 54.3247 24.8182 52.1231C24.8182 49.9215 22.9663 48.1368 20.6818 48.1368C18.3974 48.1368 16.5455 49.9215 16.5455 52.1231C16.5455 54.3247 18.3974 56.1094 20.6818 56.1094Z"
                        fill="#F7F8FD" fill-opacity="0.4" />
                    <path
                        d="M4.13636 56.1094C6.42081 56.1094 8.27274 54.3247 8.27274 52.1231C8.27274 49.9215 6.42081 48.1368 4.13636 48.1368C1.85191 48.1368 7.62939e-06 49.9215 7.62939e-06 52.1231C7.62939e-06 54.3247 1.85191 56.1094 4.13636 56.1094Z"
                        fill="#F7F8FD" fill-opacity="0.4" />
                    <path
                        d="M37.2273 72.0547C39.5117 72.0547 41.3636 70.27 41.3636 68.0684C41.3636 65.8668 39.5117 64.0821 37.2273 64.0821C34.9428 64.0821 33.0909 65.8668 33.0909 68.0684C33.0909 70.27 34.9428 72.0547 37.2273 72.0547Z"
                        fill="#F7F8FD" fill-opacity="0.4" />
                    <path
                        d="M70.3182 56.1094C72.6026 56.1094 74.4545 54.3247 74.4545 52.1231C74.4545 49.9215 72.6026 48.1368 70.3182 48.1368C68.0337 48.1368 66.1818 49.9215 66.1818 52.1231C66.1818 54.3247 68.0337 56.1094 70.3182 56.1094Z"
                        fill="#F7F8FD" fill-opacity="0.4" />
                    <path
                        d="M53.7727 88C56.0572 88 57.9091 86.2153 57.9091 84.0137C57.9091 81.8121 56.0572 80.0274 53.7727 80.0274C51.4883 80.0274 49.6364 81.8121 49.6364 84.0137C49.6364 86.2153 51.4883 88 53.7727 88Z"
                        fill="#F7F8FD" fill-opacity="0.4" />
                    <path
                        d="M4.13636 88C6.42081 88 8.27274 86.2153 8.27274 84.0137C8.27274 81.8121 6.42081 80.0274 4.13636 80.0274C1.85191 80.0274 0 81.8121 0 84.0137C0 86.2153 1.85191 88 4.13636 88Z"
                        fill="#F7F8FD" fill-opacity="0.4" />
                    <path
                        d="M86.8636 88C89.1481 88 91 86.2153 91 84.0137C91 81.8121 89.1481 80.0274 86.8636 80.0274C84.5792 80.0274 82.7273 81.8121 82.7273 84.0137C82.7273 86.2153 84.5792 88 86.8636 88Z"
                        fill="#F7F8FD" fill-opacity="0.4" />
                </svg>
            </div>

            <div class="banner-amazing-content">
                <div class="banner-amazing-content-right">
                    <div class="banner-amazing-content-right-board">
                        <div class="banner-amazing-content-right-board-line-one"></div>
                        <div class="banner-amazing-content-right-board-text">
                            <span><strong><?php echo esc_html($settings['discount_percent']); ?>%</strong>
                                تخـــــــــــفیف</span>
                        </div>
                        <div class="banner-amazing-content-right-board-line-two"></div>
                    </div>
                    <span class="banner-amazing-content-right-title"><?php echo esc_html($settings['main_title']); ?></span>
                    <span class="banner-amazing-content-right-subtitle">
                        <?php
                        $subtitle = wp_kses_post($settings['subtitle']);
                        $subtitle = str_replace(['<p>', '</p>'], '', $subtitle);
                        echo $subtitle;
                        ?>
                    </span>
                    <div class="banner-amazing-content-right-shape"></div>
                </div>

                <div class="banner-amazing-content-left">
                    <div class="banner-amazing-content-left-header">
                        <svg width="31" height="32" viewBox="0 0 31 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M12.1286 0.612305C13.4722 5.95124 13.0499 17.6588 0.612305 21.7774M29.6123 23.8487C24.6376 21.4275 13.0247 19.3904 6.37048 30.6123M4.0672 25.7816L24.7966 9.19274"
                                stroke="#F7F8FD" stroke-width="1.22384" stroke-linecap="round" />
                        </svg>
                        <p class="banner-amazing-content-left-header-title">
                            <?php echo esc_html($settings['left_header_title']); ?>
                        </p>
                        <p class="banner-amazing-content-left-header-subtitle">
                            <?php echo wp_kses($settings['left_header_text'], array('strong' => array())); ?>
                        </p>
                        <svg width="53" height="39" viewBox="0 0 53 39" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M0.625765 0.449868C7.89861 11.8768 25.7007 31.1868 40.8328 19.5647C51.1642 11.6298 40.7174 2.44066 29.7205 11.5103C18.7235 20.5799 25.8788 41.4032 52.1149 32.6627M52.1149 32.6627L47.9097 29.7493M52.1149 32.6627L47.325 38.3782"
                                stroke="#F7F8FD" stroke-width="1.5" stroke-linejoin="round" />
                        </svg>
                    </div>
                    <div class="banner-amazing-content-left-bottom">
                        <a href="<?php echo esc_url($button_url); ?>" <?php echo $button_external; ?> <?php echo $button_nofollow; ?>>
                            <span><?php echo esc_html($settings['button_text']); ?></span>
                            <svg width="34" height="34" viewBox="0 0 34 34" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M20.0747 11.4906C19.9404 11.625 19.7565 11.7098 19.5444 11.7098L11.7096 11.7098L11.7096 19.5446C11.7096 19.9547 11.3702 20.2941 10.9601 20.2941C10.55 20.2941 10.2106 19.9547 10.2106 19.5446L10.2106 10.9603C10.2106 10.5502 10.55 10.2108 10.9601 10.2108L19.5444 10.2108C19.9545 10.2108 20.2939 10.5502 20.2939 10.9603C20.301 11.1654 20.2091 11.3563 20.0747 11.4906Z"
                                    fill="#1D2977" />
                                <path
                                    d="M23.5111 23.5115C23.2212 23.8014 22.7404 23.8014 22.4505 23.5115L10.5499 11.6109C10.2599 11.321 10.2599 10.8402 10.5499 10.5502C10.8398 10.2603 11.3206 10.2603 11.6105 10.5502L23.5111 22.4508C23.801 22.7408 23.801 23.2216 23.5111 23.5115Z"
                                    fill="#1D2977" />
                            </svg>
                        </a>
                    </div>
                </div>
            </div>

            <?php if ($settings['show_timer'] === 'yes'): ?>
                <div class="banner-amazing-counter">
                    <div class="banner-amazing-counter-item">
                        <span><?php echo esc_html($time_remaining['days']); ?></span>
                        <span>روز</span>
                    </div>
                    <div class="banner-amazing-counter-item-line"></div>
                    <div class="banner-amazing-counter-item">
                        <span><?php echo esc_html($time_remaining['hours']); ?></span>
                        <span>ساعت</span>
                    </div>
                    <div class="banner-amazing-counter-item-line"></div>
                    <div class="banner-amazing-counter-item banner-amazing-counter-item-badge">
                        <span><?php echo esc_html($time_remaining['minutes']); ?></span>
                        <span>دقیقه</span>
                        <svg width="41" height="74" viewBox="0 0 41 74" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M0.5 9L8 0L10 9H0.5Z" fill="#E80645" fill-opacity="0.6" />
                            <path d="M0.5 65L8 74L10 65H0.5Z" fill="#E80645" fill-opacity="0.6" />
                            <path d="M8 0H29C35.6274 0 41 5.37258 41 12V62C41 68.6274 35.6274 74 29 74H8V0Z" fill="#E80645" />
                        </svg>
                    </div>
                    <div class="banner-amazing-counter-item-line"></div>
                    <div class="banner-amazing-counter-item">
                        <span><?php echo esc_html($time_remaining['seconds']); ?></span>
                        <span>ثانیه</span>
                    </div>
                </div>
            <?php endif; ?>

            <svg class="banner-amazing-svg" width="91" height="88" viewBox="0 0 91 88" fill="none"
                xmlns="http://www.w3.org/2000/svg">
                <path
                    d="M70.3182 39.8633C72.6026 39.8633 74.4545 38.0785 74.4545 35.8769C74.4545 33.6753 72.6026 31.8906 70.3182 31.8906C68.0337 31.8906 66.1818 33.6753 66.1818 35.8769C66.1818 38.0785 68.0337 39.8633 70.3182 39.8633Z"
                    fill="#F7F8FD" fill-opacity="0.4" />
                <path
                    d="M37.2273 39.8633C39.5117 39.8633 41.3636 38.0785 41.3636 35.8769C41.3636 33.6753 39.5117 31.8906 37.2273 31.8906C34.9428 31.8906 33.0909 33.6753 33.0909 35.8769C33.0909 38.0785 34.9428 39.8633 37.2273 39.8633Z"
                    fill="#F7F8FD" fill-opacity="0.4" />
                <path
                    d="M20.6818 39.8632C22.9663 39.8632 24.8182 38.0785 24.8182 35.8769C24.8182 33.6753 22.9663 31.8906 20.6818 31.8906C18.3974 31.8906 16.5455 33.6753 16.5455 35.8769C16.5455 38.0785 18.3974 39.8632 20.6818 39.8632Z"
                    fill="#F7F8FD" fill-opacity="0.4" />
                <path
                    d="M86.8636 23.9179C89.1481 23.9179 91 22.1332 91 19.9316C91 17.73 89.1481 15.9453 86.8636 15.9453C84.5792 15.9453 82.7273 17.73 82.7273 19.9316C82.7273 22.1332 84.5792 23.9179 86.8636 23.9179Z"
                    fill="#F7F8FD" fill-opacity="0.4" />
                <path
                    d="M70.3182 23.9179C72.6026 23.9179 74.4545 22.1332 74.4545 19.9316C74.4545 17.73 72.6026 15.9453 70.3182 15.9453C68.0337 15.9453 66.1818 17.73 66.1818 19.9316C66.1818 22.1332 68.0337 23.9179 70.3182 23.9179Z"
                    fill="#F7F8FD" fill-opacity="0.4" />
                <path
                    d="M53.7727 23.9179C56.0572 23.9179 57.9091 22.1332 57.9091 19.9316C57.9091 17.73 56.0572 15.9453 53.7727 15.9453C51.4883 15.9453 49.6364 17.73 49.6364 19.9316C49.6364 22.1332 51.4883 23.9179 53.7727 23.9179Z"
                    fill="#F7F8FD" fill-opacity="0.4" />
                <path
                    d="M20.6818 23.9179C22.9663 23.9179 24.8182 22.1332 24.8182 19.9316C24.8182 17.73 22.9663 15.9453 20.6818 15.9453C18.3974 15.9453 16.5455 17.73 16.5455 19.9316C16.5455 22.1332 18.3974 23.9179 20.6818 23.9179Z"
                    fill="#F7F8FD" fill-opacity="0.4" />
                <path
                    d="M4.13636 23.9179C6.42081 23.9179 8.27274 22.1332 8.27274 19.9316C8.27274 17.73 6.42081 15.9453 4.13636 15.9453C1.85191 15.9453 0 17.73 0 19.9316C0 22.1332 1.85191 23.9179 4.13636 23.9179Z"
                    fill="#F7F8FD" fill-opacity="0.4" />
                <path
                    d="M86.8636 7.97265C89.1481 7.97265 91 6.18791 91 3.98633C91 1.78474 89.1481 3.62419e-06 86.8636 3.5268e-06C84.5792 3.42941e-06 82.7273 1.78474 82.7273 3.98633C82.7273 6.18791 84.5792 7.97265 86.8636 7.97265Z"
                    fill="#F7F8FD" fill-opacity="0.4" />
                <path
                    d="M53.7727 7.97265C56.0572 7.97265 57.9091 6.18791 57.9091 3.98633C57.9091 1.78474 56.0572 2.21347e-06 53.7727 2.11608e-06C51.4883 2.01869e-06 49.6364 1.78474 49.6364 3.98633C49.6364 6.18791 51.4883 7.97265 53.7727 7.97265Z"
                    fill="#F7F8FD" fill-opacity="0.4" />
                <path
                    d="M37.2273 7.97265C39.5117 7.97265 41.3636 6.18791 41.3636 3.98633C41.3636 1.78474 39.5117 1.50811e-06 37.2273 1.41072e-06C34.9428 1.31333e-06 33.0909 1.78474 33.0909 3.98632C33.0909 6.18791 34.9428 7.97265 37.2273 7.97265Z"
                    fill="#F7F8FD" fill-opacity="0.4" />
                <path
                    d="M20.6818 7.97265C22.9663 7.97265 24.8182 6.18791 24.8182 3.98632C24.8182 1.78474 22.9663 8.02749e-07 20.6818 7.05359e-07C18.3974 6.07969e-07 16.5455 1.78474 16.5455 3.98632C16.5455 6.18791 18.3974 7.97265 20.6818 7.97265Z"
                    fill="#F7F8FD" fill-opacity="0.4" />
                <path
                    d="M4.13636 7.97265C6.42081 7.97265 8.27274 6.18791 8.27274 3.98632C8.27274 1.78474 6.42081 9.73899e-08 4.13636 0C1.85191 -9.73899e-08 7.62939e-06 1.78474 7.62939e-06 3.98632C7.62939e-06 6.18791 1.85191 7.97265 4.13636 7.97265Z"
                    fill="#F7F8FD" fill-opacity="0.4" />
                <path
                    d="M37.2273 23.9179C39.5117 23.9179 41.3636 22.1332 41.3636 19.9316C41.3636 17.73 39.5117 15.9453 37.2273 15.9453C34.9428 15.9453 33.0909 17.73 33.0909 19.9316C33.0909 22.1332 34.9428 23.9179 37.2273 23.9179Z"
                    fill="#F7F8FD" fill-opacity="0.4" />
                <path
                    d="M70.3182 7.97265C72.6026 7.97265 74.4545 6.18791 74.4545 3.98633C74.4545 1.78474 72.6026 2.91883e-06 70.3182 2.82144e-06C68.0337 2.72405e-06 66.1818 1.78474 66.1818 3.98633C66.1818 6.18791 68.0337 7.97265 70.3182 7.97265Z"
                    fill="#F7F8FD" fill-opacity="0.4" />
                <path
                    d="M53.7727 39.8633C56.0572 39.8633 57.9091 38.0785 57.9091 35.8769C57.9091 33.6753 56.0572 31.8906 53.7727 31.8906C51.4883 31.8906 49.6364 33.6753 49.6364 35.8769C49.6364 38.0785 51.4883 39.8633 53.7727 39.8633Z"
                    fill="#F7F8FD" fill-opacity="0.4" />
                <path
                    d="M4.13636 39.8632C6.42081 39.8632 8.27274 38.0785 8.27274 35.8769C8.27274 33.6753 6.42081 31.8906 4.13636 31.8906C1.85191 31.8906 0 33.6753 0 35.8769C0 38.0785 1.85191 39.8632 4.13636 39.8632Z"
                    fill="#F7F8FD" fill-opacity="0.4" />
                <path
                    d="M86.8636 39.8633C89.1481 39.8633 91 38.0785 91 35.8769C91 33.6753 89.1481 31.8906 86.8636 31.8906C84.5792 31.8906 82.7273 33.6753 82.7273 35.8769C82.7273 38.0785 84.5792 39.8633 86.8636 39.8633Z"
                    fill="#F7F8FD" fill-opacity="0.4" />
                <path
                    d="M70.3182 88C72.6026 88 74.4545 86.2153 74.4545 84.0137C74.4545 81.8121 72.6026 80.0274 70.3182 80.0274C68.0337 80.0274 66.1818 81.8121 66.1818 84.0137C66.1818 86.2153 68.0337 88 70.3182 88Z"
                    fill="#F7F8FD" fill-opacity="0.4" />
                <path
                    d="M37.2273 88C39.5117 88 41.3636 86.2153 41.3636 84.0137C41.3636 81.8121 39.5117 80.0274 37.2273 80.0274C34.9428 80.0274 33.0909 81.8121 33.0909 84.0137C33.0909 86.2153 34.9428 88 37.2273 88Z"
                    fill="#F7F8FD" fill-opacity="0.4" />
                <path
                    d="M20.6818 88C22.9663 88 24.8182 86.2153 24.8182 84.0137C24.8182 81.8121 22.9663 80.0274 20.6818 80.0274C18.3974 80.0274 16.5455 81.8121 16.5455 84.0137C16.5455 86.2153 18.3974 88 20.6818 88Z"
                    fill="#F7F8FD" fill-opacity="0.4" />
                <path
                    d="M86.8636 72.0547C89.1481 72.0547 91 70.27 91 68.0684C91 65.8668 89.1481 64.0821 86.8636 64.0821C84.5792 64.0821 82.7273 65.8668 82.7273 68.0684C82.7273 70.27 84.5792 72.0547 86.8636 72.0547Z"
                    fill="#F7F8FD" fill-opacity="0.4" />
                <path
                    d="M70.3182 72.0547C72.6026 72.0547 74.4545 70.27 74.4545 68.0684C74.4545 65.8668 72.6026 64.0821 70.3182 64.0821C68.0337 64.0821 66.1818 65.8668 66.1818 68.0684C66.1818 70.27 68.0337 72.0547 70.3182 72.0547Z"
                    fill="#F7F8FD" fill-opacity="0.4" />
                <path
                    d="M53.7727 72.0547C56.0572 72.0547 57.9091 70.27 57.9091 68.0684C57.9091 65.8668 56.0572 64.0821 53.7727 64.0821C51.4883 64.0821 49.6364 65.8668 49.6364 68.0684C49.6364 70.27 51.4883 72.0547 53.7727 72.0547Z"
                    fill="#F7F8FD" fill-opacity="0.4" />
                <path
                    d="M20.6818 72.0547C22.9663 72.0547 24.8182 70.27 24.8182 68.0684C24.8182 65.8668 22.9663 64.0821 20.6818 64.0821C18.3974 64.0821 16.5455 65.8668 16.5455 68.0684C16.5455 70.27 18.3974 72.0547 20.6818 72.0547Z"
                    fill="#F7F8FD" fill-opacity="0.4" />
                <path
                    d="M4.13636 72.0547C6.42081 72.0547 8.27274 70.27 8.27274 68.0684C8.27274 65.8668 6.42081 64.0821 4.13636 64.0821C1.85191 64.0821 0 65.8668 0 68.0684C0 70.27 1.85191 72.0547 4.13636 72.0547Z"
                    fill="#F7F8FD" fill-opacity="0.4" />
                <path
                    d="M86.8636 56.1094C89.1481 56.1094 91 54.3247 91 52.1231C91 49.9215 89.1481 48.1368 86.8636 48.1368C84.5792 48.1368 82.7273 49.9215 82.7273 52.1231C82.7273 54.3247 84.5792 56.1094 86.8636 56.1094Z"
                    fill="#F7F8FD" fill-opacity="0.4" />
                <path
                    d="M53.7727 56.1094C56.0572 56.1094 57.9091 54.3247 57.9091 52.1231C57.9091 49.9215 56.0572 48.1368 53.7727 48.1368C51.4883 48.1368 49.6364 49.9215 49.6364 52.1231C49.6364 54.3247 51.4883 56.1094 53.7727 56.1094Z"
                    fill="#F7F8FD" fill-opacity="0.4" />
                <path
                    d="M37.2273 56.1094C39.5117 56.1094 41.3636 54.3247 41.3636 52.1231C41.3636 49.9215 39.5117 48.1368 37.2273 48.1368C34.9428 48.1368 33.0909 49.9215 33.0909 52.1231C33.0909 54.3247 34.9428 56.1094 37.2273 56.1094Z"
                    fill="#F7F8FD" fill-opacity="0.4" />
                <path
                    d="M20.6818 56.1094C22.9663 56.1094 24.8182 54.3247 24.8182 52.1231C24.8182 49.9215 22.9663 48.1368 20.6818 48.1368C18.3974 48.1368 16.5455 49.9215 16.5455 52.1231C16.5455 54.3247 18.3974 56.1094 20.6818 56.1094Z"
                    fill="#F7F8FD" fill-opacity="0.4" />
                <path
                    d="M4.13636 56.1094C6.42081 56.1094 8.27274 54.3247 8.27274 52.1231C8.27274 49.9215 6.42081 48.1368 4.13636 48.1368C1.85191 48.1368 7.62939e-06 49.9215 7.62939e-06 52.1231C7.62939e-06 54.3247 1.85191 56.1094 4.13636 56.1094Z"
                    fill="#F7F8FD" fill-opacity="0.4" />
                <path
                    d="M37.2273 72.0547C39.5117 72.0547 41.3636 70.27 41.3636 68.0684C41.3636 65.8668 39.5117 64.0821 37.2273 64.0821C34.9428 64.0821 33.0909 65.8668 33.0909 68.0684C33.0909 70.27 34.9428 72.0547 37.2273 72.0547Z"
                    fill="#F7F8FD" fill-opacity="0.4" />
                <path
                    d="M70.3182 56.1094C72.6026 56.1094 74.4545 54.3247 74.4545 52.1231C74.4545 49.9215 72.6026 48.1368 70.3182 48.1368C68.0337 48.1368 66.1818 49.9215 66.1818 52.1231C66.1818 54.3247 68.0337 56.1094 70.3182 56.1094Z"
                    fill="#F7F8FD" fill-opacity="0.4" />
                <path
                    d="M53.7727 88C56.0572 88 57.9091 86.2153 57.9091 84.0137C57.9091 81.8121 56.0572 80.0274 53.7727 80.0274C51.4883 80.0274 49.6364 81.8121 49.6364 84.0137C49.6364 86.2153 51.4883 88 53.7727 88Z"
                    fill="#F7F8FD" fill-opacity="0.4" />
                <path
                    d="M4.13636 88C6.42081 88 8.27274 86.2153 8.27274 84.0137C8.27274 81.8121 6.42081 80.0274 4.13636 80.0274C1.85191 80.0274 0 81.8121 0 84.0137C0 86.2153 1.85191 88 4.13636 88Z"
                    fill="#F7F8FD" fill-opacity="0.4" />
                <path
                    d="M86.8636 88C89.1481 88 91 86.2153 91 84.0137C91 81.8121 89.1481 80.0274 86.8636 80.0274C84.5792 80.0274 82.7273 81.8121 82.7273 84.0137C82.7273 86.2153 84.5792 88 86.8636 88Z"
                    fill="#F7F8FD" fill-opacity="0.4" />
            </svg>
        </section>

        <?php if ($settings['show_timer'] === 'yes' && !empty($settings['end_date'])): ?>
            <script>
                jQuery(document).ready(function($) {
                    function updateTimer() {
                        var endDate = new Date('<?php echo esc_js($settings['end_date']); ?>').getTime();
                        var now = new Date().getTime();
                        var distance = endDate - now;

                        if (distance < 0) {
                            $('.banner-amazing-counter').html('<div class="timer-expired">پیشنهاد به پایان رسیده است</div>');
                            return;
                        }

                        var days = Math.floor(distance / (1000 * 60 * 60 * 24));
                        var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                        var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                        var seconds = Math.floor((distance % (1000 * 60)) / 1000);

                        // به روزرسانی مقادیر
                        $('.banner-amazing-counter-item:eq(0) span:first').text(String(days).padStart(2, '0'));
                        $('.banner-amazing-counter-item:eq(1) span:first').text(String(hours).padStart(2, '0'));
                        $('.banner-amazing-counter-item:eq(2) span:first').text(String(minutes).padStart(2, '0'));
                        $('.banner-amazing-counter-item:eq(3) span:first').text(String(seconds).padStart(2, '0'));
                    }

                    // به روزرسانی هر ثانیه
                    setInterval(updateTimer, 1000);
                    updateTimer(); // فراخوانی اولیه
                });
            </script>
<?php endif;
    }
}
