<?php

function styles_color()
{
?>
    <div class="wrap flexbox-lamkadeh-setting">
        <label for="main_color"><?php echo __("رنگ اصلی: ", "lamkadeh") ?></label>
        <input type="color" name="main_color" class="form-input-text" value="<?php echo esc_attr(get_option("main_color", "#1D2977")) ?>" id="main_color">
    </div>

    <div class="wrap flexbox-lamkadeh-setting">
        <label for="main_complementary_color"><?php echo __("رنگ مکمل: ", "lamkadeh") ?></label>
        <input type="color" name="main_complementary_color" class="form-input-text" value="<?php echo esc_attr(get_option("main_complementary_color", "#FFD701")) ?>" id="main_complementary_color">
    </div>

    <div class="wrap flexbox-lamkadeh-setting">
        <label for="main_black_color"><?php echo __("رنگ مشکی: ", "lamkadeh") ?></label>
        <input type="color" name="main_black_color" class="form-input-text" value="<?php echo esc_attr(get_option("main_black_color", "#020308A3")) ?>" id="main_black_color">
    </div>

    <div class="wrap flexbox-lamkadeh-setting">
        <label for="main_gray_color"><?php echo __("رنگ خاکستری: ", "lamkadeh") ?></label>
        <input type="color" name="main_gray_color" class="form-input-text" value="<?php echo esc_attr(get_option("main_gray_color", "#0E0B0114")) ?>" id="main_gray_color">
    </div>

    <div class="wrap flexbox-lamkadeh-setting">
        <label for="main_red_color"><?php echo __("رنگ قرمز: ", "lamkadeh") ?></label>
        <input type="color" name="main_red_color" class="form-input-text" value="<?php echo esc_attr(get_option("main_red_color", "#E80645")) ?>" id="main_red_color">
    </div>
<?php
}

function add_dynamic_css_variables() {
    $main_color = get_option("main_color", "#1D2977");
    $main_complementary_color = get_option("main_complementary_color", "#FFD701");
    $main_black_color = get_option("main_black_color", "#020308A3");
    $main_gray_color = get_option("main_gray_color", "#0E0B0114");
    $main_red_color = get_option("main_red_color", "#E80645");
    
    echo "
    <style>
    :root {
        --main-color: " . esc_attr($main_color) . ";
        --main-complementary-color: " . esc_attr($main_complementary_color) . ";
        --main-black-color: " . esc_attr($main_black_color) . ";
        --main-gray-color: " . esc_attr($main_gray_color) . ";
        --main-red-color: " . esc_attr($main_red_color) . ";
    }
    </style>
    ";
}
add_action('wp_head', 'add_dynamic_css_variables');