jQuery(document).ready(function ($) {
    function checkSaveButtonVisibility() {
        const saveButton = document.querySelector('.button-save-lamkadeh');
        const activeTab = document.querySelector('.tab-content.active');
        if (activeTab && activeTab.id === 'smarthub') {
            saveButton.style.display = 'none';
        } else {
            saveButton.style.display = 'block';
        }
    }
    checkSaveButtonVisibility();
    $(".lamkadeh-sidebar li").on("click", function () {
        $(".lamkadeh-sidebar li").removeClass("active");
        $(this).addClass("active");
        $(".tab-content").removeClass("active");
        $("#" + $(this).data("tab")).addClass("active");
        checkSaveButtonVisibility();
    });
    $("#lamkadeh-settings-form").on("submit", function (e) {
        e.preventDefault();

        const btn = $(".button-save-lamkadeh");
        const originalText = btn.text();

        btn.text("در حال ذخیره‌سازی...").prop("disabled", true);

        $.ajax({
            type: "POST",
            url: lamkadeh_ajax.url,
            data: $(this).serialize() + "&action=lamkadeh_save_settings",
            success: function (response) {
                if (response.success) {
                    lamkadeh_notify(response.data, "success");
                } else {
                    lamkadeh_notify(response.data, "error");
                }
            },
            error: function () {
                lamkadeh_notify("خطا در ارتباط با سرور.", "error");
            },
            complete: function () {
                btn.text(originalText).prop("disabled", false);
            }
        });
    });

    let file_frame;
    $(document).on("click", ".upload-logo-btn", function (e) {
        e.preventDefault();
        if (file_frame) {
            file_frame.open();
            return;
        }
        file_frame = wp.media({
            title: lamkadeh_ajax.i18n.SelectOrUploadLogo,
            button: {
                text: lamkadeh_ajax.i18n.SelectLogo
            },
            multiple: false
        });
        file_frame.on("select", function () {
            let attachment = file_frame.state().get("selection").first().toJSON();
            $("#site_logo_theme").val(attachment.url);
            $(".logo-preview").html('<img src="' + attachment.url + '" style="max-width:100px;">');
        });
        file_frame.open();
    });

    $(document).on("click", ".upload-image_theme_myaccount_two-btn", function (e) {
        e.preventDefault();
        if (file_frame) {
            file_frame.open();
            return;
        }
        file_frame = wp.media({
            title: lamkadeh_ajax.i18n.SelectOrUploadLogo,
            button: {
                text: lamkadeh_ajax.i18n.SelectLogo
            },
            multiple: false
        });
        file_frame.on("select", function () {
            let attachment = file_frame.state().get("selection").first().toJSON();
            $("#image_theme_myaccount_two").val(attachment.url);
            $(".image_theme_myaccount_two-preview").html('<img src="' + attachment.url + '" style="max-width:100px;">');
        });
        file_frame.open();
    });

    $(document).on("click", ".upload-image_theme_myaccount_one-btn", function (e) {
        e.preventDefault();
        if (file_frame) {
            file_frame.open();
            return;
        }
        file_frame = wp.media({
            title: lamkadeh_ajax.i18n.SelectOrUploadLogo,
            button: {
                text: lamkadeh_ajax.i18n.SelectLogo
            },
            multiple: false
        });
        file_frame.on("select", function () {
            let attachment = file_frame.state().get("selection").first().toJSON();
            $("#image_theme_myaccount_one").val(attachment.url);
            $(".image_theme_myaccount_one-preview").html('<img src="' + attachment.url + '" style="max-width:100px;">');
        });
        file_frame.open();
    });

    $(document).on("click", ".upload-icon-btn", function (e) {
        e.preventDefault();
        let target = $(this).data('target');

        if (file_frame) {
            file_frame.open();
            return;
        }

        file_frame = wp.media({
            title: 'انتخاب آیکون',
            button: {
                text: 'انتخاب آیکون'
            },
            multiple: false
        });

        file_frame.on("select", function () {
            let attachment = file_frame.state().get("selection").first().toJSON();
            $("#" + target).val(attachment.url);
            $(this).closest('.wrap').find('.icon-preview').html('<img src="' + attachment.url + '" style="max-width:80px;">');
        });

        file_frame.open();
    });

    $(document).on("click", ".upload-screenshot-btn", function (e) {
        e.preventDefault();
        let target = $(this).data('target');

        if (file_frame) {
            file_frame.open();
            return;
        }

        file_frame = wp.media({
            title: 'انتخاب اسکرین‌شات',
            button: {
                text: 'انتخاب تصویر'
            },
            multiple: false
        });

        file_frame.on("select", function () {
            let attachment = file_frame.state().get("selection").first().toJSON();
            $("#" + target).val(attachment.url);
            $(this).closest('.wrap').find('.screenshot-preview').html('<img src="' + attachment.url + '" style="max-width:100px;">');
        });

        file_frame.open();
    });

    $(document).on("click", ".upload-image-image-error-404", function (e) {
        e.preventDefault();
        if (file_frame) {
            file_frame.open();
            return;
        }
        file_frame = wp.media({
            title: lamkadeh_ajax.i18n.SelectImageError404,
            button: {
                text: lamkadeh_ajax.i18n.ImageError404
            },
            multiple: false
        });
        file_frame.on("select", function () {
            let attachment = file_frame.state().get("selection").first().toJSON();
            $("#image_error_404").val(attachment.url);
            $(".image-error-404-preview").html('<img src="' + attachment.url + '" style="max-width:100px;">');
        });
        file_frame.open();
    });

    $(document).on("click", ".upload-image-welcome-btn", function (e) {
        e.preventDefault();
        if (file_frame) {
            file_frame.open();
            return;
        }
        file_frame = wp.media({
            title: lamkadeh_ajax.i18n.SelectOrUploadImageWelcome,
            button: {
                text: lamkadeh_ajax.i18n.SelectImageWelcome
            },
            multiple: false
        });
        file_frame.on("select", function () {
            let attachment = file_frame.state().get("selection").first().toJSON();
            $("#site_image_welcome").val(attachment.url);
            $(".site-image-welcome-preview").html('<img src="' + attachment.url + '" style="max-width:50px;border-radius:20px">');
        });
        file_frame.open();
    });

    $(document).on("click", ".upload-image_box_one_footer-btn", function (e) {
        e.preventDefault();
        if (file_frame) {
            file_frame.open();
            return;
        }
        file_frame = wp.media({
            title: lamkadeh_ajax.i18n.SelectOrUploadLogo,
            button: {
                text: lamkadeh_ajax.i18n.SelectLogo
            },
            multiple: false
        });
        file_frame.on("select", function () {
            let attachment = file_frame.state().get("selection").first().toJSON();
            $("#image_box_one_footer").val(attachment.url);
            $(".image_box_one_footer-preview").html('<img src="' + attachment.url + '" style="max-width:100px;">');
        });
        file_frame.open();
    });


    $(document).on("click", ".upload-image_box_two_footer-btn", function (e) {
        e.preventDefault();
        if (file_frame) {
            file_frame.open();
            return;
        }
        file_frame = wp.media({
            title: lamkadeh_ajax.i18n.SelectOrUploadLogo,
            button: {
                text: lamkadeh_ajax.i18n.SelectLogo
            },
            multiple: false
        });
        file_frame.on("select", function () {
            let attachment = file_frame.state().get("selection").first().toJSON();
            $("#image_box_two_footer").val(attachment.url);
            $(".image_box_two_footer-preview").html('<img src="' + attachment.url + '" style="max-width:100px;">');
        });
        file_frame.open();
    });

    $(document).on("click", ".upload-image_box_three_footer-btn", function (e) {
        e.preventDefault();
        if (file_frame) {
            file_frame.open();
            return;
        }
        file_frame = wp.media({
            title: lamkadeh_ajax.i18n.SelectOrUploadLogo,
            button: {
                text: lamkadeh_ajax.i18n.SelectLogo
            },
            multiple: false
        });
        file_frame.on("select", function () {
            let attachment = file_frame.state().get("selection").first().toJSON();
            $("#image_box_three_footer").val(attachment.url);
            $(".image_box_three_footer-preview").html('<img src="' + attachment.url + '" style="max-width:100px;">');
        });
        file_frame.open();
    });

    $(document).on("click", ".upload-image_box_four_footer-btn", function (e) {
        e.preventDefault();
        if (file_frame) {
            file_frame.open();
            return;
        }
        file_frame = wp.media({
            title: lamkadeh_ajax.i18n.SelectOrUploadLogo,
            button: {
                text: lamkadeh_ajax.i18n.SelectLogo
            },
            multiple: false
        });
        file_frame.on("select", function () {
            let attachment = file_frame.state().get("selection").first().toJSON();
            $("#image_box_four_footer").val(attachment.url);
            $(".image_box_four_footer-preview").html('<img src="' + attachment.url + '" style="max-width:100px;">');
        });
        file_frame.open();
    });
});

// Notification Alarm
function lamkadeh_notify(message, type = "success") {
    let $container = jQuery("#lamkadeh-toast-container");
    if ($container.length === 0) {
        jQuery("body").append('<div id="lamkadeh-toast-container"></div>');
        $container = jQuery("#lamkadeh-toast-container");
    }
    let toast = jQuery('<div class="lamkadeh-toast ' + type + '">' + message + '</div>');
    $container.append(toast);
    setTimeout(() => {
        toast.addClass("show");
    }, 100);
    setTimeout(() => {
        toast.removeClass("show");
        setTimeout(() => {
            toast.remove();
        }, 300);
    }, 4000);
}

// Configure Sms
document.addEventListener("DOMContentLoaded", function () {
    let smsProvider = document.getElementById("sms_provider");
    let parsGreenRow = document.querySelector(".parsgreen_row");
    let meliPayamakRow = document.querySelector(".melipayamak_row");
    let smsIrRow = document.querySelector(".sms_ir_row");
    let farazSmsRow = document.querySelector(".farazsms_row");
    let textareaMessage = document.getElementById("hidden-textarea-for-sms-ir");

    function updateVisibility() {
        let value = smsProvider.value;

        [parsGreenRow, meliPayamakRow, smsIrRow, farazSmsRow].forEach(row => {
            if (row) row.style.display = "none";
        });
        if (textareaMessage) textareaMessage.style.display = "none";

        switch (value) {
            case "parsgreen":
                if (parsGreenRow) parsGreenRow.style.display = "block";
                if (textareaMessage) textareaMessage.style.display = "block";
                break;
            case "melipayamak":
                if (meliPayamakRow) meliPayamakRow.style.display = "block";
                if (textareaMessage) textareaMessage.style.display = "block";
                break;
            case "sms_ir":
                if (smsIrRow) smsIrRow.style.display = "block";
                if (textareaMessage) textareaMessage.style.display = "block";
                break;
            case "farazsms":
                if (farazSmsRow) farazSmsRow.style.display = "block";
                if (textareaMessage) textareaMessage.style.display = "block";
                break;
        }
    }

    jQuery(document).ready(function ($) {
        $("#sms_provider").select2({
            allowClear: true
        });

        $("#sms_provider").on("select2:select select2:unselect", function () {
            updateVisibility();
        });
    });

    smsProvider.addEventListener("change", updateVisibility);

    updateVisibility();
});

document.addEventListener("DOMContentLoaded", function () {
    const editors = [
        { id: "custom-html", mode: "htmlmixed" },
        { id: "custom-css", mode: "css" },
        { id: "custom-js", mode: "javascript" }
    ];

    editors.forEach(e => {
        const textarea = document.getElementById(e.id);
        if (textarea) {
            CodeMirror.fromTextArea(textarea, {
                mode: e.mode,
                lineNumbers: true,
                matchBrackets: true,
                autoCloseBrackets: true,
                styleActiveLine: true,
                theme: "default",
                lineWrapping: true
            });
        }
    });
});