document.addEventListener("DOMContentLoaded", function () {
  const items = document.querySelectorAll(".lamkadeh-additional-info-item");

  items.forEach((item, index) => {
    const counterEl = item.querySelector(".counter-attribute-name");
    if (counterEl) {
      const number = (index + 1).toString().padStart(2, "0");
      counterEl.textContent = number;
    }
  });
});

document.addEventListener("DOMContentLoaded", function () {
  const emailAndRatingContainer = document.querySelector(".email_and_rating");
  const ratingField = document.querySelector(".comment-form-rating");

  if (emailAndRatingContainer && ratingField) {
    emailAndRatingContainer.appendChild(ratingField);
  }
});

document.addEventListener("DOMContentLoaded", function () {

    const reviewForm = document.getElementById("review_form_wrapper");
    const reviewTab = document.getElementById("tab-reviews");

    if (reviewForm && reviewTab) {
        reviewTab.appendChild(reviewForm);
    }

});

(function () {
    'use strict';

    // صبر برای لود اولیه DOM
    function onReady(fn) {
        if (document.readyState !== 'loading') {
            fn();
        } else {
            document.addEventListener('DOMContentLoaded', fn);
        }
    }

    onReady(function () {
        // پیدا کردن بخش کامنت‌ها
        const commentsSection = document.querySelector('#comments');

        if (!commentsSection) {
            // اگر #comments وجود نداشت، هیچ کاری نمی‌کنیم
            return;
        }

        // پیدا کردن یا ایجاد کانتینر داخلی
        let commentsContainer = commentsSection.querySelector('.lamkadeh-single-review');

        // اگر کانتینر داخلی وجود نداشت، آن را ایجاد می‌کنیم
        if (!commentsContainer) {
            commentsContainer = document.createElement('div');
            commentsContainer.className = 'lamkadeh-single-review';

            // اضافه کردن کانتینر جدید به #comments
            commentsSection.appendChild(commentsContainer);
        }

        // پیدا کردن همه کامنت‌هایی که در #comments هستند اما در .lamkadeh-single-review نیستند
        function moveExistingCommentsToContainer() {
            const allCommentElements = commentsSection.querySelectorAll(
                'div[id^="comment-"], li[id^="comment-"], .lamkadeh-single-review-item'
            );

            // فیلتر کامنت‌هایی که در داخل کانتینر نیستند
            const commentsToMove = Array.from(allCommentElements).filter(el => {
                return !commentsContainer.contains(el) && commentsSection.contains(el);
            });

            // انتقال کامنت‌ها به داخل کانتینر
            commentsToMove.forEach(el => {
                try {
                    commentsContainer.appendChild(el);
                } catch (e) {
                    console.warn('خطا در انتقال کامنت:', e);
                }
            });

            return commentsToMove.length > 0;
        }

        // سلکتور برای کامنت‌های بی‌سرپرست (آنهایی که خارج از #comments هستند)
        const orphanSelector = [
            'div[id^="comment-"]',
            'li[id^="comment-"]',
            '.lamkadeh-single-review-item'
        ].join(',');

        // تابع کمکی برای گرفتن شماره‌ی id
        function parseCommentId(el) {
            const idAttr = el.id || '';
            const m = idAttr.match(/comment-(\d+)/);
            return m ? parseInt(m[1], 10) : null;
        }

        // تابعی که کامنت‌های بی‌سرپرست را پیدا و منتقل می‌کند
        function moveOrphanComments() {
            // همه المان‌هایی که با سلکتور می‌آیند
            const nodes = Array.from(document.querySelectorAll(orphanSelector));

            // فیلتر: فقط آنهایی که در داخل #comments نیستند
            const orphans = nodes.filter(el => {
                return !commentsSection.contains(el);
            });

            if (!orphans.length) return false;

            // مرتب‌سازی بر اساس شماره‌ی comment-ID
            orphans.sort((a, b) => {
                const ia = parseCommentId(a);
                const ib = parseCommentId(b);

                if (ia !== null && ib !== null) return ia - ib;
                if (ia !== null) return -1;
                if (ib !== null) return 1;
                return 0;
            });

            // انتقال هر orphan به انتهای commentsContainer
            orphans.forEach(el => {
                try {
                    commentsContainer.appendChild(el);
                } catch (e) {
                    // اگر append شکست خورد
                    try {
                        const clone = el.cloneNode(true);
                        commentsContainer.appendChild(clone);
                        el.parentNode && el.parentNode.removeChild(el);
                    } catch (err) {
                        console.warn('خطا در انتقال کامنت بی‌سرپرست:', err);
                    }
                }
            });

            return true;
        }

        // اول: انتقال کامنت‌های موجود که در کانتینر نیستند
        moveExistingCommentsToContainer();

        // دوم: انتقال کامنت‌های بی‌سرپرست
        moveOrphanComments();

        // یک MutationObserver برای کامنت‌های جدید
        const observer = new MutationObserver(function (mutationsList) {
            let foundNewComments = false;

            for (let mutation of mutationsList) {
                if (mutation.addedNodes && mutation.addedNodes.length) {
                    // بررسی هر نود اضافه شده
                    mutation.addedNodes.forEach(node => {
                        if (node.nodeType === Node.ELEMENT_NODE) {
                            // بررسی اگر این نود خودش یک کامنت است
                            if (node.matches && node.matches(orphanSelector)) {
                                foundNewComments = true;
                            }
                            // یا اگر داخلش کامنت دارد
                            if (node.querySelector && node.querySelector(orphanSelector)) {
                                foundNewComments = true;
                            }
                        }
                    });
                }
            }

            if (foundNewComments) {
                // ابتدا کامنت‌های موجود را بررسی کنیم
                moveExistingCommentsToContainer();
                // سپس کامنت‌های بی‌سرپرست
                moveOrphanComments();
            }
        });

        // شروع مشاهده DOM
        observer.observe(document.body, {
            childList: true,
            subtree: true
        });

        // قطع observer پس از 10 ثانیه
        setTimeout(() => {
            observer.disconnect();
        }, 10000);

        // همچنین یک بار دیگر پس از تاخیر کوتاه اجرا کنیم
        // برای پوشش کامنت‌هایی که ممکن است با تاخیر لود شوند
        setTimeout(() => {
            moveExistingCommentsToContainer();
            moveOrphanComments();
        }, 1000);

    });

})();
